/*
 * usbg_storage_conf.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2009 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Configuration Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_CONF_H__
#define __USBG_STORAGE_CONF_H__

#include <linux/usb/specific_gadget/usb_node_info.h>
#include <linux/usb/specific_gadget/usb_config.h>

/* Gadget FunctionΥǥƥƥ					*/
#define MY_NAME "usbg_storage"
#define MY_DESC "USB Gadget MassStorage function driver"
#define MY_MINOR USB_MINOR_MASSSTORAGE
#define MY_NODE  USB_NODE_MASSSTORAGE

#define MY_VER "01.23.001"

/* Endpointǽ							*/
#define GSTORAGE_EP_SEND	0	/* INž0			*/
#define GSTORAGE_EP_RECEIVE	1	/* OUTž1			*/

#define GSTORAGE_EP_NUM 3 /* Endpoint: 3ܤΥɥݥȤMTP DualMode */
                          /* MSC func_drvǤϡݤϤ뤬EPϻѤʤ */
#define GSTORAGE_REQ_NUM_BY_EP	10	/* 1 EPΥꥯȿ	*/
/* EP_NUM*REQ_NUM_BY_EP*sizeof(usb_request)ꥯѥХåե */

#define GSTORAGE_DMA_ENABLE
#define GSTORAGE_IO_BLOCK_DEV

// NEED TO BE CHANGED...
// #define GSTORAGE_USE_BOOTMEM

#include <asm/io.h>
#define USB_CNF_VAL_LEN 4
static inline uint32_t __get_conf_val(uintptr_t adr){
	uint32_t ret;
	void* vp;
	vp = ioremap((unsigned long)adr, (unsigned long)USB_CNF_VAL_LEN);
	ret = *((uint32_t*)vp);
	iounmap(vp);
	return ret;
}
#define GSTORAGE_BOOTMEM_BASE 0
#define GSTORAGE_BOOTMEM_SIZE 0

#ifdef STORAGE_NAND_NO_MBR
#define NAND2_BLOCKS     0x003BAA69  /* /dev/nand2Υ() */
#define NAND2_OFFSET_LBA 0x00015517
#endif

/*[GPL]STORAGE_MOVINAND_MULTILUN_NO_MBRʲä*/
#ifdef STORAGE_MOVINAND_MULTILUN_NO_MBR

	#define GSTORAGE_PARTITION1_BLOCKSZ		MMC_PART1_BLOCKSZ  /* Partition1Υ() */
	#define GSTORAGE_PARTITION1_OFFSET_LBA	MMC_PART1_OFFSET
	#define GSTORAGE_PARTITION2_BLOCKSZ		MMC_PART2_BLOCKSZ  /* Partition2Υ() */
	#define GSTORAGE_PARTITION2_OFFSET_LBA	MMC_PART2_OFFSET

	#define GSTORAGE_LEADING_PART1_DEVICE_NODE_NAME		MMC_LEADING_PART1_DEVICE_NODE_NAME
	#define GSTORAGE_LEADING_PART2_DEVICE_NODE_NAME		MMC_LEADING_PART2_DEVICE_NODE_NAME
	#define GSTORAGE_PARTITION1_DEVICE_NODE_NAME		MMC_PART1_DEVICE_NODE_NAME
	#define GSTORAGE_PARTITION2_DEVICE_NODE_NAME		MMC_PART2_DEVICE_NODE_NAME
	
#endif

#endif	/* __USBG_STORAGE_CONF_H__ */
