/**
 *	@file	usbg_still.h
 *	@brief	USB SICD(Still Image Capture Device class)
 *	
 *		Copyright 2005,2006,2008 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_USBG_STILL_H__
#define __UAPI_USBG_STILL_H__

#define USBG_STILL_BUFFER_NUM		2
#define USBG_STILL_BUFFER_SIZE		(32*1024*2) // 32K x 2

enum {
	USBG_STILL_EVENT_CANCEL = 0,
	USBG_STILL_EVENT_DEVICE_RESET,
	USBG_STILL_EVENT_READ_COMP,
	USBG_STILL_EVENT_WRITE_COMP,
	USBG_STILL_EVENT_READ_COMP_WITH_RESET,
	USBG_STILL_EVENT_START_NORMAL,
	USBG_STILL_EVENT_START_WITH_DUAL,
};

struct usbg_io_comp_arg {
	void *addr;
	int   size;
};

#endif /* __UAPI_USBG_STILL_H__ */
