/*
 * arch/arm64/mm/iomap.c
 *
 * Copyright 2020 Sony Imaging Products & Solutions Inc.
 *
 * This code is based on arch/arm/mm/iomap.c
 */
/*
 *  linux/arch/arm/mm/iomap.c
 *
 * Map IO port and PCI memory spaces so that {read,write}[bwl] can
 * be used to access this memory.
 */
#include <linux/pci.h>
#include <linux/io.h>

#ifdef CONFIG_PCI
void pci_iounmap(struct pci_dev *dev, void __iomem *addr)
{
	if ((unsigned long)addr >= VMALLOC_START &&
	    (unsigned long)addr < VMALLOC_END)
		iounmap(addr);
}
EXPORT_SYMBOL(pci_iounmap);
#endif
