
#include "platform_sys.h"

#include "srt.h"
#include "common.h"
#include "dmm_mgr.h"
#include "logger_defs.h"

#include <new>

dmm_mgr::~dmm_mgr() {}

dmm_mgr* dmm_mgr::GetInstance() {
    static dmm_mgr dmm_manager{};
    return &dmm_manager;
}

bool dmm_mgr::Set(void *dmmPtr, uint64_t dmmSz) {
    LOGF(srt_logging::cnlog.Note, "[IN]");

    if (nullptr != this->dmmPtr_ || 0 != this->dmmSz_ || 0 != this->curOffs_) {
        LOGF(srt_logging::cnlog.Error, "Already Set");
        return false;
    }

    this->dmmPtr_ = static_cast<uint8_t *>(dmmPtr);
    this->dmmSz_ = static_cast<size_t>(dmmSz);
    this->curOffs_ = 0;
    LOGF(srt_logging::cnlog.Note, "Set to p=%p, z=0x%zX", this->dmmPtr_, this->dmmSz_);
    LOGF(srt_logging::cnlog.Note, "[OUT]");

    return true;
}

void dmm_mgr::Reset() {
    LOGF(srt_logging::cnlog.Note, "[IN]");
    LOGF(srt_logging::cnlog.Note, "Reset");
    this->dmmPtr_ = nullptr;
    this->dmmSz_ = 0;
    this->curOffs_ = 0;
    LOGF(srt_logging::cnlog.Note, "[OUT]");
}

void* dmm_mgr::DmmMalloc(size_t size) {
    LOGF(srt_logging::cnlog.Note, "[IN]");

    if (!this->dmmPtr_ || !this->dmmSz_) {
        LOGF(srt_logging::cnlog.Error, "Failed to DmmMalloc(region empty)");
        return nullptr;
    }

    uint8_t *const dmmEndPtr = this->dmmPtr_ + this->dmmSz_;

    uint8_t *newWritePtr = this->dmmPtr_ + this->curOffs_;
    uint8_t *newWriteEndPtr = newWritePtr + size;

    if (newWriteEndPtr > dmmEndPtr) {
        LOGF(srt_logging::cnlog.Error, "Failed to DmmMalloc");
        return nullptr;
    }

    this->curOffs_ += size;

    LOGF(srt_logging::cnlog.Note, "new_offs:%zX, ret:%p", this->curOffs_, newWritePtr);

    LOGF(srt_logging::cnlog.Note, "[OUT]");
    return newWritePtr;
}

void* dmm_mgr::DmmNew(size_t size) {
    LOGF(srt_logging::cnlog.Note, "[IN]");
    void *retval = this->DmmMalloc(size);
    if (!retval) {
        throw std::bad_alloc();
    }
    LOGF(srt_logging::cnlog.Note, "[OUT]");
    return retval;
}

dmm_mgr::dmm_mgr()
    : dmmPtr_(nullptr)
    , dmmSz_(0)
    , curOffs_(0)
{
    LOGF(srt_logging::cnlog.Note, "[IN]");
    LOGF(srt_logging::cnlog.Note, "dmm_mgr constructing");
    LOGF(srt_logging::cnlog.Note, "dmm_mgr constructing");
    LOGF(srt_logging::cnlog.Note, "[OUT]");
}
