/*
 * arch/arm64/kernel/debug.S
 *
 * Debugging macro include header
 *
 * Copyright 2018 Sony Corporation
 *
 * This code is based on arch/arm/kernel/debug.S
 */
/*
 *  linux/arch/arm/kernel/debug.S
 *
 *  Copyright (C) 1994-1999 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  32-bit debugging code
 */
#include <linux/linkage.h>
#include <asm/assembler.h>

		.text
		.pushsection ".idmap.text", "ax"
/*
 * Some debugging routines (useful if you've got MM problems and
 * printk isn't working).  For DEBUGGING ONLY!!!  Do not leave
 * references to these in a production kernel!
 */

#include <mach/debug-macro.S>

		.macro	addruart_current, rx, tmp1, tmp2
		addruart	\tmp1, \tmp2
		mrs	\rx, sctlr_el1
		tst	\rx, #1
		bne	1001f
		mov	\rx, \tmp1
		b	1002f
1001:
		mov	\rx, \tmp2
1002:
		.endm

/*
 * Useful debugging routines
 */
ENTRY(printhex64)
		mov	x1, #16
		b	printhex
ENDPROC(printhex64)

ENTRY(printhex32)
		mov	x1, #8
		b	printhex
ENDPROC(printhex32)

ENTRY(printhex8)
		mov	x1, #8
		b	printhex
ENDPROC(printhex8)

ENTRY(printhex4)
		mov	x1, #4
		b	printhex
ENDPROC(printhex4)

ENTRY(printhex2)
		mov	x1, #2
printhex:	adr	x2, hexbuf
		add	x3, x2, x1
		strb	wzr, [x3]
1:		and	x1, x0, #15
		mov	x0, x0, lsr #4
		cmp	x1, #10
		bge	2f
		add	x1, x1, #'0'
		b	3f
2:
		add	x1, x1, #'a' - 10
3:
		strb	w1, [x3, #-1]!
		cmp	x3, x2
		b.ne	1b
		mov	x0, x2
		b	printascii
ENDPROC(printhex2)

hexbuf:		.space 32

		.ltorg

ENTRY(printascii)
		addruart_current x3, x1, x2
		b	2f
1:		waituart w2, x3
		senduart w1, x3
		busyuart w2, x3
		cmp	w1, #'\n'
		b.eq	3f
2:
		ldrb	w1, [x0], #1
		cbnz	w1, 1b
		ret
3:
		mov	w1, #'\r'
		b	1b
ENDPROC(printascii)

ENTRY(printch)
		addruart_current x3, x1, x2
		waituart w2, x3
		senduart w0, x3
		busyuart w2, x3
		ret
ENDPROC(printch)

#ifdef CONFIG_DEBUG_EARLY
ENTRY(_printch)
		// w8: ch
		// x5,x6,x7: corrupted
		addruart_current x5, x6, x7
		waituart w6, x5
		senduart w8, x5
		busyuart w6, x5
		ret
ENDPROC(_printch)
#endif /* CONFIG_DEBUG_EARLY */
		.ltorg
		.popsection
