/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/clk-provider.h>

struct cxd_clk_mux {
        struct clk_hw hw;
        struct regmap *regmap;
        u32 sta_reg;
        u32 set_reg;
        u32 clr_reg;
        u32 mask;
        u8 shift;
        u8 width;
        u8 flags;
        spinlock_t *lock;
};

struct clk *cxd_clk_register_mux(struct device *dev, const char *name,
                const char * const *parent_names, u32 num_parent, unsigned long flags,
                struct regmap *regmap, u32 sta_ofs, u32 set_ofs, u32 clr_ofs,
                u8 bit_ofs, u8 bit_width, u8 clk_gate_flags, spinlock_t *lock);

