/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "cxd-clk-define.h"
#include "cxd-clk.h"
#include "cxd-clk-gate.h"
#include "cxd-clk-mux.h"
#include "cxd-clk-div.h"

static struct clk *cxd_clk_fix_add(struct cxd_clk_fix_node *clk_fix)
{
        return clk_register_fixed_rate(NULL, clk_fix->name, NULL, 0, clk_fix->freq);
}

static struct clk *cxd_clk_gate_add(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_gate_node *clk_gate)
{
        struct regmap *regmap = ctrl_data->clk_regmap;

        return cxd_clk_register_gate(NULL, clk_gate->name, clk_gate->parent_name, 0, regmap,
                        clk_gate->sts_reg_ofs, CLK_SET_REG(clk_gate->sts_reg_ofs), CLK_CLR_REG(clk_gate->sts_reg_ofs),
                        clk_gate->bit_off, 0, &ctrl_data->lock);
}

static struct clk *cxd_clk_mux_add(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_mux_node *clk_mux)
{
        struct regmap *regmap = ctrl_data->clk_regmap;

        return cxd_clk_register_mux(NULL, clk_mux->name, clk_mux->parent_names, clk_mux->parent_num, 0, regmap,
                        clk_mux->sts_reg_ofs, CLK_SET_REG(clk_mux->sts_reg_ofs), CLK_CLR_REG(clk_mux->sts_reg_ofs),
                        clk_mux->shift, clk_mux->width, 0, &ctrl_data->lock);
}

static struct clk *cxd_clk_div_add(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_div_node *clk_div)
{
        struct regmap *regmap = ctrl_data->clk_regmap;

        return cxd_clk_register_div(NULL, clk_div->name, clk_div->parent_name, 0, regmap,
                        clk_div->reg_ofs, clk_div->shift, clk_div->width, 0, &ctrl_data->lock);
}

void cxd_clk_fix_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_fix_node *clk_fix, int cf_num)
{
        int i, max_num;
        struct cxd_clk_fix_node *cf;

        max_num = ctrl_data->clk_num;

        for (i = 0; i < cf_num; i++) {
                cf = &clk_fix[i];

                if (cf->id >= max_num) {
                        err_print("clk fix id %u: over range %d\n", cf->id, max_num);
                        continue;
                }

                ctrl_data->clk[cf->id] = cxd_clk_fix_add(cf);
                if (IS_ERR(ctrl_data->clk[cf->id]))
                        err_print("fix clk id %u: register failed with %ld\n", cf->id, PTR_ERR(ctrl_data->clk[cf->id]));
        }
}

void cxd_clk_gate_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_gate_node *clk_gate, int cg_num)
{
        int i, max_num;
        struct cxd_clk_gate_node *cg;

        max_num = ctrl_data->clk_num;

        for (i = 0; i < cg_num; i++) {
                cg = &clk_gate[i];

                if (cg->id >= max_num) {
                        err_print("clk gate id %u: over range %d\n", cg->id, max_num);
                        continue;
                }

                ctrl_data->clk[cg->id] = cxd_clk_gate_add(ctrl_data, cg);
                if (IS_ERR(ctrl_data->clk[cg->id]))
                        err_print("gate clk id %u: register failed with %ld\n", cg->id, PTR_ERR(ctrl_data->clk[cg->id]));
        }
}

void cxd_clk_mux_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_mux_node *clk_mux, int cm_num)
{
        int i, max_num;
        struct cxd_clk_mux_node *cm;

        max_num = ctrl_data->clk_num;

        for (i = 0; i < cm_num; i++) {
                cm = &clk_mux[i];

                if (cm->id >= max_num) {
                        err_print("clk mux id %u: over range %d\n", cm->id, max_num);
                        continue;
                }

                ctrl_data->clk[cm->id] = cxd_clk_mux_add(ctrl_data, cm);
                if (IS_ERR(ctrl_data->clk[cm->id]))
                        err_print("gate clk id %u: register failed with %ld\n", cm->id, PTR_ERR(ctrl_data->clk[cm->id]));
        }
}

void cxd_clk_div_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_div_node *clk_div, int cd_num)
{
        int i, max_num;
        struct cxd_clk_div_node *cd;

        max_num = ctrl_data->clk_num;

        for (i = 0; i < cd_num; i++) {
                cd = &clk_div[i];

                if (cd->id >= max_num) {
                        err_print("clk div id %u: over range %d\n", cd->id, max_num);
                        continue;
                }

                ctrl_data->clk[cd->id] = cxd_clk_div_add(ctrl_data, cd);
                if (IS_ERR(ctrl_data->clk[cd->id]))
                        err_print("div clk id %u: register failed with %ld\n", cd->id, PTR_ERR(ctrl_data->clk[cd->id]));
        }
}

