/*
 * Copyright 2018 Sony Imaging Products & Solutions Inc.
 * Copyright 2018 Sony Corporation.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/clk-provider.h>

#define SET_REG_OFS     0x04
#define CLR_REG_OFS     0x08

#define CLK_SET_REG(x) (x + SET_REG_OFS)
#define CLK_CLR_REG(x) (x + CLR_REG_OFS)

struct cxd_clk_fix_node {
        int id;
        const char *name;
        u32 freq;
};

struct cxd_clk_div_node {
        int id;
        const char *name;
        const char *parent_name;
        u32 reg_ofs;
        u8 shift;
        u8 width;
};

struct cxd_clk_gate_node {
        int id;
        const char *name;
        const char *parent_name;
        u32 sts_reg_ofs;
        u8 bit_off;
};

struct cxd_clk_mux_node {
        int id;
        const char *name;
        const char * const *parent_names;
        u32 parent_num;
        u32 sts_reg_ofs;
        u8 shift;
        u8 width;
};

struct cxd_clk_ctrl_data {
        int clk_num;
        struct clk **clk;
        struct regmap *clk_regmap;
        struct clk_onecell_data clk_data;
        spinlock_t lock;
};

void cxd_clk_fix_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_fix_node *clk_fix, int cf_num);
void cxd_clk_gate_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_gate_node *clk_gate, int cg_num);
void cxd_clk_mux_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_mux_node *clk_mux, int cm_num);
void cxd_clk_div_set(struct cxd_clk_ctrl_data *ctrl_data, struct cxd_clk_div_node *clk_div, int cd_num);

