/*
 *  platform.c
 *
 *  Copyright 2018 Sony Corporation.
 *  Copyright 2019,2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include "pcie_dma.h"

#include <mach/platform.h>
#include <linux/pcidma.h>
#include "platform.h"
#include "regs.h"

struct pci_info_t pcie_dmacs[PCIDMA_PCIE_MAX] = {
	[PCIDMA_PCIE_I] = {
		.name = PCIE_NAME_I,
		.irq  = PCIE_IRQ_I,
		.ctl  = IO_ADDRESSP(PCIE_CTRL_I),
		.dmac = IO_ADDRESSP(PCIE_CTRL_I) + DMA_OFFSET,
		.phy  = IO_ADDRESSP(PCIE_PHY_I),
	},
	[PCIDMA_PCIE_N] = {
		.name = PCIE_NAME_N,
		.irq  = PCIE_IRQ_N,
		.ctl  = IO_ADDRESSP(PCIE_CTRL_N),
		.dmac = IO_ADDRESSP(PCIE_CTRL_N) + DMA_OFFSET,
		.phy  = IO_ADDRESSP(PCIE_PHY_N),
	},
#ifndef CONFIG_ARCH_CXD900XX_FPGA
	[PCIDMA_PCIE_C] = {
		.name = PCIE_NAME_C,
		.irq  = PCIE_IRQ_C,
		.ctl  = IO_ADDRESSP(PCIE_CTRL_C),
		.dmac = IO_ADDRESSP(PCIE_CTRL_C) + DMA_OFFSET,
		.phy  = IO_ADDRESSP(PCIE_PHY_C),
	},
	[PCIDMA_PCIE_M0] = {
		.name = PCIE_NAME_M0,
		.irq  = PCIE_IRQ_M0,
		.ctl  = IO_ADDRESSP(PCIE_CTRL_M0),
		.dmac = IO_ADDRESSP(PCIE_CTRL_M0) + DMA_OFFSET,
		.phy  = IO_ADDRESSP(PCIE_PHY_M0),
	},
	[PCIDMA_PCIE_M1] = {
		.name = PCIE_NAME_M1,
		.irq  = PCIE_IRQ_M1,
		.ctl  = IO_ADDRESSP(PCIE_CTRL_M1),
		.dmac = IO_ADDRESSP(PCIE_CTRL_M1) + DMA_OFFSET,
		.phy  = IO_ADDRESSP(PCIE_PHY_M1),
	},
#endif /* CONFIG_ARCH_CXD900XX_FPGA */
};
