/*
 *  regs.h
 *
 *  Copyright 2018 Sony Corporation.
 *  Copyright 2019,2020 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __PCIEDMA_REGS_H__
#define __PCIEDMA_REGS_H__

#define ATU_OFFSET	0x300000
#define DMA_OFFSET	0x380000
/* DMAC overall */
#define DMAWR_EN        0x0c
# define DMA_EN_ENABLE	 0x00000001
# define DMA_EN_DISABLE	 0x00000000
#define DMAWR_DOORBELL  0x10
# define DMA_STOP	 0x80000000U
#define DMARD_EN        0x2c
#define DMARD_DOORBELL  0x30
#define DMAWR_INTSTAT   0x4c
#define DMAWR_INTMASK   0x54
#define DMAWR_INTCLR    0x58
#define DMAWR_ERR	0x5c
#define DMAWR_LLERR_EN	0x90
# define DMA_LLLAIE	 0x00ff0000
#define DMARD_INTSTAT   0xa0
#define DMARD_INTMASK   0xa8
#define DMARD_INTCLR    0xac
# define DMA_INT_DONE	 0x0000ffffU
# define DMA_INT_ABORT	 0xffff0000U
# define DMA_INT_ALL	 (DMA_INT_DONE|DMA_INT_ABORT)
# define DMA_INT_DONE_BIT	0
# define DMA_INT_ABORT_BIT	16
#define DMARD_ERR_L	0xb4
#define DMARD_ERR_H	0xb8
#define DMARD_LLERR_EN	0xc4

/* DMAC CH */
#define DMAWR_PWR(x)	(0x128 + (x) * 4)
#define DMARD_PWR(x)	(0x168 + (x) * 4)
# define DMA_CH_PWR_EN	 0x1
#define DMA_CH_BASE(x)	(0x200 + (x) * 0x200)
#define DMA_CH_WR	0x000
#define DMA_CH_RD	0x100
#define DMAWR_CH(x)	(DMA_CH_BASE(x) + DMA_CH_WR)
#define DMARD_CH(x)	(DMA_CH_BASE(x) + DMA_CH_RD)
#define DMA_CTRL1	0x00
# define DMA_CTRL1_CB	 0x001
# define DMA_CTRL1_TCB	 0x002
# define DMA_CTRL1_LLP	 0x004
# define DMA_CTRL1_LIE	 0x008
# define DMA_CTRL1_CS    0x060
# define DMA_CTRL1_CS_RUN  0x020
# define DMA_CTRL1_CS_HALT 0x040
# define DMA_CTRL1_CS_STOP 0x060
# define DMA_CTRL1_CCS	 0x100
# define DMA_CTRL1_LLE	 0x200
#define DMA_CTRL2	0x04
#define DMA_SIZE	0x08
#define DMA_SRC_L	0x0c
#define DMA_SRC_H	0x10
#define DMA_DST_L	0x14
#define DMA_DST_H	0x18
#define DMA_LLP_L	0x1c
#define DMA_LLP_H	0x20

/* CTL */
#define PCIE_CAP	0x70
#define LINK_CTL	(PCIE_CAP+PCI_EXP_LNKCTL)

/* SIDEBAND */
#define APP_PM_REQ	0x20264
# define APP_XFER_PENDING (1U << 5)
#define LTSSM_STATE	0x20268
# define LTSSM_SHIFT	15
# define LTSSM_MASK	0x3F
# define S_L0		0x11
# define S_L0S		0x12

#endif /* __PCIEDMA_REGS_H__ */
