/*
 * drivers/udif/mach-cxd900xx/include/mach/regs-ddrc.h
 *
 * CXD90057 DDRC registers
 *
 * Copyright 2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __MACH_CXD900XX_REGS_DDRC_H__
#define __MACH_CXD900XX_REGS_DDRC_H__

#ifdef __ASSEMBLY__
#define BIT(nr)		(UL(1) << (nr))
#endif /* __ASSEMBLY__ */

#define N_DDRC	4
#define N_DDR_CS 2

/* ddr_ctrl API parameters */
#define DDRC_SREF	(1)
#define DDRC_DPD	(2)

/* DDRC registers */
#define DDR_CTL(x)	((x) << 2)

#define LPCMD_REG	DDR_CTL(146)
#define  LPCMD_SH	8
#define  LPCMD_MCKG	(0x1U<<5)
#define  LPCMD_MCCKG	(0x2U<<5)
#define  LPCMD_SREF	(0x4U<<2)
#define  LPCMD_DPD	(0x6U<<2)
#define  LPCMD_ENTER	(0x1U<<0)
#define  LPCMD_EXIT	(0x2U<<0)
#define  LPCMD_MASK	(0x7f << LPCMD_SH)
#define  LPCMD_DPD_CMD	((LPCMD_MCKG|LPCMD_DPD|LPCMD_ENTER)<<LPCMD_SH)
#define  LPCMD_SREF_CMD	((LPCMD_MCKG|LPCMD_SREF|LPCMD_ENTER)<<LPCMD_SH)

#define LPSTATE_CS0	(DDR_CTL(156)+3)
#define LPSTATE_CS1	(DDR_CTL(157)+0)
# define LPSTATE_MASK	 0x7f
# define LPSTATE_IDLE	 0x40
#define LP_AUTO_ENTRY_EN (DDR_CTL(157)+1)

#define WRMODE_REG	DDR_CTL(177)
#define  WRMODE_EXEC	BIT(25)
#define  WRMODE_CS_ALL	BIT(24)
#define  WRMODE_SINGLE	BIT(23)
#define  WRMODE_CS	8
#define  MR17		17

#define MRSINGLE0_REG	DDR_CTL(197)
# define MRSINGLE0_SH	0
# define MRSINGLE0_MASK	(0xffUL << MRSINGLE0_SH)

#define MRSINGLE1_REG	DDR_CTL(205)
# define MRSINGLE1_SH	16
# define MRSINGLE1_MASK	(0xffUL << MRSINGLE1_SH)

#define CTRLBUSY_REG	DDR_CTL(270)
#define  CTRLBUSY_BIT	BIT(16)

#define INTSTAT_REG	DDR_CTL(275)
#define  INTSTAT_WRMODE		BIT(26)
#define  INTSTAT_LPCMD_DONE	BIT(5)

#define INTACK_REG	DDR_CTL(277)

#define CSMAP_REG	DDR_CTL(267)
#define  CSMAP_SHIFT	24
#define  CSMAP_MASK	0x3

/* DDRPHY registers */
#define PHYREG50	0x50
#define  R_SRE_IO_N	BIT(4)

#endif /* __MACH_CXD900XX_REGS_DDRC_H__ */
