/*
 * mach-cxd900xx/include/mach/uart.h
 *
 * UART header for ARCH_CXD900XX
 *
 * Copyright 2018,2019 Sony Imaging Products & Solutions Inc
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD900XX_UART_H__
#define __ARCH_CXD900XX_UART_H__

#ifdef CONFIG_CXD900XX_UART_IO_INIT
#include <mach/platform.h>
#include <mach/regs-gpio.h>
#include <mach/regs-octrl.h>

/* UART0 pin */
#define GPIO_UART	3
#define GPIO_UART0_RXD	(1 << 0)
#define GPIO_UART0_TXD	(1 << 1)
#define OCTRL_UART	1
#define OCTRL_UART0_RXD	(1 << 17)
#define OCTRL_UART0_TXD	(1 << 18)
#endif /* CONFIG_CXD900XX_UART_IO_INIT */

#if defined(CONFIG_ARCH_CXD900XX_FVP)
# define UARTPA 0x1C090000
# define UARTVA_EARLY 0xffffff8020090000
# define UARTVA_IOMAP UART_EARLY
#elif defined(CONFIG_ARCH_CXD900XX_QEMU)
# define UARTPA 0x09000000
# define UARTVA_EARLY 0xffffff8020000000
# define UARTVA_IOMAP UART_EARLY
#else
# define UARTPA 0xf1000000
# define UARTVA_EARLY 0xffffff8020000000
# define UARTVA_IOMAP 0xfffffffff1000000
#endif

#ifdef CONFIG_ARCH_CXD900XX_FPGA
#define __UART_CLK	CONFIG_ARCH_CXD900XX_FPGACLK
#define __UART_BAUD	115200
#else
/* UART baudrate clock 12MHz, 460800baud */
#define __UART_CLK	12000000
#define __UART_BAUD	460800
#endif
#define __UART_BAUD_I	(__UART_CLK/(__UART_BAUD*16))
#define __UART_BAUD_F	(((__UART_CLK*64)+(__UART_BAUD*8))/(__UART_BAUD*16)-(__UART_BAUD_I*64))
#define __UART_8N1_NO_FIFO 0x70

#ifdef __ASSEMBLY__
		.macro	addruart, rp, rv
		mov	\rp, #UARTPA
#ifdef CONFIG_DEBUG_EARLY
		ldr	\rv, =UARTVA_EARLY
#else
		ldr	\rv, =UARTVA_IOMAP
#endif /* CONFIG_DEBUG_EARLY */
		.endm

		.macro	uart_portconfig
#ifdef CONFIG_CXD900XX_UART_IO_INIT
		// PORTSEL UART0 TXD,RXD
		ldr	x5, =PA_GPIO(GPIO_UART,PORT)
		mov	w6, #(GPIO_UART0_TXD|GPIO_UART0_RXD)
		str	w6, [x5, #GPIO_CLR]
		// Pull OFF
		ldr	x5, =CXD900XX_OCTRL(OCTRL_UART,PULL)
		mov	w6, #(OCTRL_UART0_TXD|OCTRL_UART0_RXD)
		str	w6, [x5, #OCTRL_CLR]
#endif /* CONFIG_CXD900XX_UART_IO_INIT */
		.endm
#endif /* __ASSEMBLY__ */
#endif /* !__ARCH_CXD900XX_UART_H__ */
