/*
 * drivers/usb/f_usb/udif_usb_otg.h
 *
 * Copyright (C) 2011-2012 FUJITSU SEMICONDUCTOR LIMITED
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * ALL RIGHTS RESERVED, COPYRIGHT (C) SOCIONEXT INC. 2015
 * LICENSED MATERIAL - PROGRAM PROPERTY OF SOCIONEXT INC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*--------------------------------------------------------------------------*
 * drivers/usb/scd/scd_device.c
 *
 * OTG and, Platform bus driver operations
 *
 * Copyright 2011 Sony Corporation
 *
 * This file is part of the HS-OTG Controller Driver SCD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *---------------------------------------------------------------------------*/

#ifndef _UDIF_USB_OTG_H_
#define _UDIF_USB_OTG_H_
#define FUSB_VERSION			20180626U

#define FUSB_OTG_OK			0

#define FUSB_OTG_FLAG_OFF		0
#define FUSB_OTG_FLAG_ON		1U

enum {
	FUSB_OTG_REG_CH = 0,
	FUSB_USB_VBUS_CH,
	FUSB_USB_ID_CH,
	FUSB_CH_MAX_NUM,
};

#define FUSB_PROC_NAME			"fusb"

#define FUSB_IPRESET_MS_TIME		1U

#define FUSB_DEVICE_CONNETCT_TIMER	100U

#ifndef TEST_USB_CNTL_DRV

/* #define FUSB_USE_USB_ID              (1) */

/* Release   */
#define fusb_lock(lock) 		udif_spin_lock(lock)
#define fusb_unlock(lock)		udif_spin_unlock(lock)
#define fusb_lock_irq(lock,flags) 		udif_spin_lock_irqsave(lock,flags)
#define fusb_unlock_irq(lock,flags)		udif_spin_unlock_irqrestore(lock,flags)
#else  /* #ifndef TEST_FUSB_DRV */
/* USB Controller Driver Test */
#define fusb_lock(lock) {						\
		fusb_lock_cnt++;					\
		udif_spin_lock(lock);					\
	}
#define fusb_unlock(lock) {						\
		udif_spin_unlock(lock); 				\
		fusb_lock_cnt--;					\
	}
#define fusb_lock_irq(lock,flags) {				\
		fusb_lock_irq_cnt++;					\
		udif_spin_lock_irqsave(lock,flags);		\
	}
#define fusb_unlock_irq(lock,flags) {			\
		udif_spin_unlock_irqrestore(lock,flags); 	\
		fusb_lock_irq_cnt--;					\
	}
#endif /* #ifndef TEST_GPIO_DRV */

enum usb_otg_port_type {
	USB_OTG_VBUS_PORT0 = 0,
	USB_OTG_VBUS_PORT1,
	USB_OTG_VBUS_PORT_MAX,
};

struct fusb_notify_control {   /* ex fusb_notify_control */
	UDIF_LIST event_anchor;
	int (*notify) (void *p);

	UDIF_VA otg_regs;

	UDIF_SPINLOCK lock;
	unsigned long flags;
	UDIF_TASKLET event_tasklet;			/**< tasklet   */
	UDIF_IRQ usb_vbus_irqn[USB_OTG_VBUS_PORT_MAX];	/**< VBUS IRQ  */
	UDIF_IRQ usb_id_irqn;				/**< ID IRQ    */

	int cid;
	enum usb_otg_vbus_stat vbus[USB_OTG_VBUS_PORT_MAX];
	int gadget_con;
	int init_comp_flag;
	int start_comp_flag;

	struct timer_list con_timer;
};

struct fusb_otg_event_container {
	union usb_otg_event event;	/**< event      */
	UDIF_LIST event_list;		/**< event list */
};

static int fusb_read_proc(UDIF_PROC_READ *proc);

static UDIF_ERR fusb_notify_otg_init(UDIF_VP data);
static UDIF_ERR fusb_notify_otg_exit(UDIF_VP data);
static UDIF_ERR fusb_notify_otg_probe(const UDIF_DEVICE * dev, UDIF_CH ch, UDIF_VP data);
static UDIF_ERR fusb_notify_otg_remove(const UDIF_DEVICE * dev, UDIF_CH ch, UDIF_VP data);
static UDIF_ERR fusb_notify_otg_suspend(const UDIF_DEVICE * dev, UDIF_CH ch, UDIF_VP data);
static UDIF_ERR fusb_notify_otg_resume(const UDIF_DEVICE * dev, UDIF_CH ch, UDIF_VP data);
static UDIF_ERR fusb_notify_otg_shutdown(const UDIF_DEVICE * dev, UDIF_CH ch, UDIF_VP data);

static void fusb_signal_event(UDIF_ULONG data);
static void fusb_signal_event_interrupt(struct fusb_notify_control *fusb, union usb_otg_event *event);
#ifdef FUSB_USE_USB_ID
static irqreturn_t fusb_interrupt_usb_id(int irq, void *p);
#endif
static irqreturn_t fusb_interrupt_usb_vbus0(int irq, void *p);
static irqreturn_t fusb_interrupt_usb_vbus1(int irq, void *p);
static void fusb_notify_cid(struct fusb_notify_control *fusb, int current_cid, bool forced);
static void fusb_notify_vbus(struct fusb_notify_control *fusb, enum usb_otg_vbus_stat current_vbus, enum usb_otg_port_type port, bool forced);

static void fusb_con_timer_func(unsigned long data);

#endif  /* _UDIF_USB_OTG_H_ */
