/*
 * drivers/usb/f_usb/usb_dwc3_regs.c
 *
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/of.h>
#include <linux/kthread.h>

#include "usb_dwc3_regs.h"
#include "usb_otg_resource.h"

void fusb_get_controller_regs(struct fusb_controller_regs_t *p, void __iomem *base)
{
	p->host_regs = base;
	p->gadget_regs = base + DWC3_DEVICE_REGS_START;
	p->global_regs = base + DWC3_GLOBALS_REGS_START;
	p->otg_regs = base + DWC3_OTG_REGS_START;
}

static const struct of_device_id of_fusb_controller_regs_match[] = {
	{
		.compatible = "snps,fusb_dwc3regs"
	},
	{},
};
MODULE_DEVICE_TABLE(of, of_fusb_controller_regs_match);

static int fusb_controller_regs_probe(struct platform_device *pdev);
static int fusb_controller_regs_remove(struct platform_device *pdev);
static struct platform_driver fusb_controller_regs_drv = {
	.probe  = fusb_controller_regs_probe,
	.remove = fusb_controller_regs_remove,
	.driver = {
		.name = "dwc3regs",
		.of_match_table = of_match_ptr(of_fusb_controller_regs_match),
	},
};

static int __worker(void *parent)
{
	/*printk(KERN_INFO "%s\n", __FUNCTION__);*/
	set_current_state(TASK_INTERRUPTIBLE);
	platform_driver_unregister(&fusb_controller_regs_drv);
	wake_up_process(parent);
	return 0;
}

static int fusb_controller_regs_probe(struct platform_device *pdev)
{
	struct resource *res;

	res = platform_get_resource(pdev, IORESOURCE_MEM, 0);
	if (!res) {
		printk(KERN_ERR "%s platform_get_resource fail\n", __FUNCTION__);
		return -EINVAL;
	}

	/*printk(KERN_INFO "%s res.start=0x%x, res.end=0x%x, res.flags=0x%lx\n", __FUNCTION__, res->start, res->end, res->flags);*/
	fusb_setup_controller_regs(res);
	fusb_setup_controller_name(&pdev->dev);

	kthread_run(__worker, current, "fusb_controller_regs_worker");
	schedule();

	return 0;
}

static int fusb_controller_regs_remove(struct platform_device *pdev)
{
	return 0;
}

static int __init fusb_controller_regs_init(void)
{
	return platform_driver_register(&fusb_controller_regs_drv);
}
arch_initcall(fusb_controller_regs_init);
static void __exit fusb_controller_regs_exit(void)
{
}
module_exit(fusb_controller_regs_exit);
