/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __USBG_SEN_CONF_H__
#define  __USBG_SEN_CONF_H__

#include <linux/usb/specific_gadget/usb_node_info.h>


#define USBG_SEN_NAME	"USB ST"
#define USBG_SEN_DESC	"USB ST function driver"
#define USBG_SEN_VER	"02.00.000"

#define USBG_SE_NAME	"USB SE"
#define USBG_SE_MINOR	USB_MINOR_SE
#define USBG_SE_NODE	USB_NODE_SE

#define USBG_TE_NAME	"USB TE"
#define USBG_TE_MINOR	USB_MINOR_TE
#define USBG_TE_NODE	USB_NODE_TE

/* Endpoint ID	*/
enum {
	USBG_EPID_SE_TX	=0,
	USBG_EPID_SE_RX,
	USBG_EPID_TE_TX,
	USBG_EPID_TE_RX,
	USBG_EPID_NBROF
};

#define USBG_SEN_DEBUG_ERR
// #define USBG_SEN_DEBUG_INF
// #define USBG_SEN_DEBUG_API
// #define USBG_SEN_DEBUG_FNC

#define USBG_SEN_SEMAPHORE
//#define USBG_SEN_SPINLOCK

/* Buffer Allocation method */
#define SENSER_KMALLOC_XFERBUF

#define USBG_SEN_IF_NR	1	/* Inteface				*/

#define DEF_LDISC_TX_REQBUF_SZ	64
#define DEF_LDISC_RX_REQBUF_SZ	512 /* BulkκPacketʬϼХåեѰդ */

#define DEF_SEN_XFER_REQBUF_SZ	0x8000

#define DEF_SEN_TX_PHYS_REQBUF_SZ	((ssize_t)(~0U>>1))
#define DEF_SEN_RX_PHYS_REQBUF_SZ	((ssize_t)(~0U>>1))

#endif  // __USBG_SEN_CONF_H__
