/*
 * usbg_storage_cmd.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2008,2009,2010 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Command Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_CMD_H__            /* ť󥯥롼ɥ顼ɻ */
#define __USBG_STORAGE_CMD_H__
/*

 󥯥롼ɥե                                                 
*/
#include "usbg_storage_debug.h"
#include <linux/usb/specific_gadget/usbg_storage.h>
#include <linux/usb/specific_gadget/usb_serial.h>
/*

                                                              
*/
/* PACKETޥɼ¹ԥơ */
#define GSTORAGE_CMD__STATUS_PASS                   0
#define GSTORAGE_CMD__STATUS_FAIL                   1
#define GSTORAGE_CMD__STATUS_FATAL                  2
#define GSTORAGE_CMD__STATUS_CONTINUE               3

/* Ƽ Packet ޥɤ Operation Code -------------------------------*/
#define GSTORAGE_CMD__OPCODE_INQUIRY                0x12
#define GSTORAGE_CMD__OPCODE_MODE_SENSE6            0x1A
#define GSTORAGE_CMD__OPCODE_MODE_SENSE10           0x5A
#define GSTORAGE_CMD__OPCODE_PREVENT_ALLOW          0x1E
#define GSTORAGE_CMD__OPCODE_READ6                  0x08
#define GSTORAGE_CMD__OPCODE_READ10                 0x28
#define GSTORAGE_CMD__OPCODE_READ12                 0xA8
#define GSTORAGE_CMD__OPCODE_READ_BUFFER            0x3C
#define GSTORAGE_CMD__OPCODE_READ_CAPACITY          0x25
#define GSTORAGE_CMD__OPCODE_READ_FORMAT_CAPACITIES 0x23
#define GSTORAGE_CMD__OPCODE_REQUEST_SENSE          0x03
#define GSTORAGE_CMD__OPCODE_SEEK                   0x2B
#define GSTORAGE_CMD__OPCODE_START_STOP_UNIT        0x1B
#define GSTORAGE_CMD__OPCODE_SYNCHRONIZE_CACHE      0x35
#define GSTORAGE_CMD__OPCODE_UNIT_READY             0x00
#define GSTORAGE_CMD__OPCODE_VENDOR_SPECIFIC        0xDB
#define GSTORAGE_CMD__OPCODE_VERIFY                 0x2F
#define GSTORAGE_CMD__OPCODE_WRITE10                0x2A
#define GSTORAGE_CMD__OPCODE_WRITE12                0xAA
#define GSTORAGE_CMD__OPCODE_WRITE_BUFFER           0x3B

/* Vendor Command Code -------------------------------------------------*/
#define GSTORAGE_CMD__VENDOR_SET_WRITE_PROTECT      0x13

/* SENSE KEY, ASC, ASCQ ǡ -----------------------------------*/
#define GSTORAGE_CMD__SK_NO_SENSE                   0x000000
#define GSTORAGE_CMD__SK_DRIVE_NOT_READY            0x020401
#define GSTORAGE_CMD__SK_NO_MEDIA                   0x023A00
#define GSTORAGE_CMD__SK_WRITE_SECTOR_ERROR         0x030300
#define GSTORAGE_CMD__SK_READ_SECTOR_ERROR          0x031100
#define GSTORAGE_CMD__SK_MEDIA_ERROR                0x033000
#define GSTORAGE_CMD__SK_MEDIA_READ_ERROR           0x033001
#define GSTORAGE_CMD__SK_MEDIA_FORMAT_ERROR         0x033002
#define GSTORAGE_CMD__SK_INVALID_COMMAND            0x052000
#define GSTORAGE_CMD__SK_INVALID_LBA                0x052100
#define GSTORAGE_CMD__SK_INVALID_FIELD              0x052400
#define GSTORAGE_CMD__SK_LUN_NOT_SUPPORTED          0x052500
#define GSTORAGE_CMD__SK_SAVING_PARAM_NOT_SUPPORTED 0x053900
#define GSTORAGE_CMD__SK_MEDIUM_REMOVAL_PREVENTED   0x055302
#define GSTORAGE_CMD__SK_MEDIA_CHANGED              0x062800
#define GSTORAGE_CMD__SK_RESET_OCCURRED             0x062900
#define GSTORAGE_CMD__SK_WRITE_PROTECTED            0x072700

#define GSTORAGE_CMD__SK_HARDWARE_ERROR             0x040000

/* Request Sense Length ------------------------------------------------*/
#define GSTORAGE_LEN__REQUEST_SENSE_STD     0x12

/* Inquiry Data VPD ----------------------------------------------------*/
#define GSTORAGE_VPD__PAGECODE_SUPPORTED_VPD        0x00
#define GSTORAGE_VPD__PAGECODE_SERIAL_NUM           0x80
#define GSTORAGE_VPD__PAGECODE_DEVICE_IDENTIFIER    0x83
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_CODE_SET    0x01
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_PROTOCOL_ID 0x0F
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_ID_TYPE     0x03
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_ID_LEN      0x08
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_NAA         0x02
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_ASSOCIATION 0x00
#define GSTORAGE_VPD__DEVICE_IDENTIFIER_PIV         0x00
#define GSTORAGE_VPD__IEEE_COMPANY_ID_SONY          0x080046

/* ޥ --------------------------------------------------------------*/
#define GSTORAGE_CONVSENSE_EXTCMD(sk,sense)                              \
        (( sk = (((unsigned int)(sense)->senseKey) << 16)    | \
                ( (unsigned int)(sense)->additional.sensCode)    ))

/*

                                                                
*/
/************************/
/* ޥɷǡ */
/************************/
typedef struct  _GSTORAGE_CMD__CdbInquiry           GSTORAGE_CMD__CdbInquiry;
typedef struct  _GSTORAGE_CMD__DatVPDHead           GSTORAGE_CMD__DatVPDHead;
typedef struct  _GSTORAGE_CMD__DatVPD00             GSTORAGE_CMD__DatVPD00;
typedef struct  _GSTORAGE_CMD__DatVPD80             GSTORAGE_CMD__DatVPD80;
typedef struct  _GSTORAGE_CMD__DatVPD83             GSTORAGE_CMD__DatVPD83;
typedef struct  _GSTORAGE_CMD__DatVPD               GSTORAGE_CMD__DatVPD;
typedef struct  _GSTORAGE_CMD__CdbModeSense6        GSTORAGE_CMD__CdbModeSense6;
typedef struct  _GSTORAGE_CMD__CdbModeSense10       GSTORAGE_CMD__CdbModeSense10;
typedef struct  _GSTORAGE_CMD__DatPageParam         GSTORAGE_CMD__DatPageParam;
typedef struct  _GSTORAGE_CMD__DatMsPage            GSTORAGE_CMD__DatMsPage;
typedef struct  _GSTORAGE_CMD__DatModeSense6        GSTORAGE_CMD__DatModeSense6;
typedef struct  _GSTORAGE_CMD__DatModeSense10       GSTORAGE_CMD__DatModeSense10;
typedef struct  _GSTORAGE_CMD__CdbPreventAllow      GSTORAGE_CMD__CdbPreventAllow;
typedef struct  _GSTORAGE_CMD__CdbRead6             GSTORAGE_CMD__CdbRead6;
typedef struct  _GSTORAGE_CMD__CdbRead10            GSTORAGE_CMD__CdbRead10;
typedef struct  _GSTORAGE_CMD__CdbRead12            GSTORAGE_CMD__CdbRead12;
typedef struct  _GSTORAGE_CMD__CdbReadCapa          GSTORAGE_CMD__CdbReadCapa;
typedef struct  _GSTORAGE_CMD__DatReadCapa          GSTORAGE_CMD__DatReadCapa;
typedef struct  _GSTORAGE_CMD__CdbReadFmtCapa       GSTORAGE_CMD__CdbReadFmtCapa;
typedef struct  _GSTORAGE_CMD__DatReadFmtCapa       GSTORAGE_CMD__DatReadFmtCapa;
typedef struct  _GSTORAGE_CMD__CdbRequestSense      GSTORAGE_CMD__CdbRequestSense;
typedef struct  _GSTORAGE_CMD__DatRequestSense      GSTORAGE_CMD__DatRequestSense;
typedef struct  _GSTORAGE_CMD__DatRequestSenseDvd   GSTORAGE_CMD__DatRequestSenseDvd;
typedef struct  _GSTORAGE_CMD__CdbSeek              GSTORAGE_CMD__CdbSeek;
typedef struct  _GSTORAGE_CMD__CdbStartStop         GSTORAGE_CMD__CdbStartStop;
typedef struct  _GSTORAGE_CMD__CdbSynchronizeCache  GSTORAGE_CMD__CdbSynchronizeCache;
typedef struct  _GSTORAGE_CMD__CdbTestUnit          GSTORAGE_CMD__CdbTestUnit;
typedef struct  _GSTORAGE_CMD__CdbVerify            GSTORAGE_CMD__CdbVerify;
typedef struct  _GSTORAGE_CMD__CdbWrite10           GSTORAGE_CMD__CdbWrite10;
typedef struct  _GSTORAGE_CMD__CdbWrite12           GSTORAGE_CMD__CdbWrite12;

/* Inquiry ******************************************************************/
struct _GSTORAGE_CMD__CdbInquiry {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 12h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_evpd           : 1;    /* EVPD                         */
    unsigned char f1_obsolete       : 1;    /* Obsolete ( 0h )              */
    unsigned char f6_reserved1      : 6;    /* reserved ( 0h )              */
    /* byte 2 ==============================================================*/
    unsigned char pageCode;                 /* PAGE CODE                    */
    /* byte 3 - 4 ==========================================================*/
    unsigned char AL[2];                    /* Allocation Length            */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__DatVPDHead {
    /* byte 0 ==============================================================*/
    unsigned char f5_pdt            : 5;    /* PDT                          */
    unsigned char f3_pq             : 3;    /* PQ                           */
    /* byte 1 ==============================================================*/
    unsigned char pageCode;                 /* PAGE CODE                    */
    /* byte 2 - 3 ==========================================================*/
    unsigned char pageLen[2];               /* PAGE LENGTH                  */
};

struct _GSTORAGE_CMD__DatVPD00 {
    /* byte 4 - 6 ==========================================================*/
    unsigned char pageList[3];              /* VPD Page List                */
};

struct _GSTORAGE_CMD__DatVPD80 {
    /* byte 4 - 15 ==========================================================*/
    unsigned char SN[USB_SERIAL_A_SIZE];    /* Serial Number                */
};

struct _GSTORAGE_CMD__DatVPD83 {
    /* byte 4 ==============================================================*/
    unsigned char f4_codeSet        : 4;    /* CODE SET                     */
    unsigned char f4_protocolID     : 4;    /* PROTOCOL IDENTIFIER          */
    /* byte 5 ==============================================================*/
    unsigned char f4_IDType         : 4;    /* ID type                      */
    unsigned char f2_association    : 2;    /* ASSOCIATION                  */
    unsigned char f1_reserved5      : 1;    /* reserved                     */
    unsigned char f1_piv            : 1;    /* PIV                          */
    /* byte 6 ==============================================================*/
    unsigned char reserved6;                /* reserved                     */
    /* byte 7 ==============================================================*/
    unsigned char id_length;                /* IDENTIFIER LENGTH            */
    /* byte 8 ==============================================================*/
    unsigned char f4_VSIA           : 4;    /* VS ID A                      */
    unsigned char f4_NAA            : 4;    /* NAA                          */
    /* byte 9 ==============================================================*/
    unsigned char VSIA;                     /* VS ID A                      */
    /* byte 10 - 12 =========================================================*/
    unsigned char ieeeCompanyID[3];         /* IEEE COMPANY_ID              */
    /* byte 13 - 15 ========================================================*/
    unsigned char VSIB[3];                  /* VS ID B                      */
};

struct _GSTORAGE_CMD__DatVPD {
    /* Header ==============================================================*/
    GSTORAGE_CMD__DatVPDHead    vpdhd;      /* VPD Header                   */
    /* Pages ===============================================================*/
    union {                                 /* union : Page Parameters      */
        GSTORAGE_CMD__DatVPD00  vpd00;      /* for 0x00                     */
        GSTORAGE_CMD__DatVPD80  vpd80;      /* for 0x80                     */
        GSTORAGE_CMD__DatVPD83  vpd83;      /* for 0x83                     */
                                            /* PageɲûϤɲ       */
    } page;                                 /*                              */
};    


/* Mode Sense ***************************************************************/
struct _GSTORAGE_CMD__CdbModeSense6 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 5Ah )       */
    /* byte 1 ==============================================================*/
    unsigned char f3_reserved1      : 3;    /* reserved ( 0h )              */
    unsigned char f1_dbd            : 1;    /* DBD                          */
    unsigned char f4_reserved1      : 4;    /* reserved ( 0h )              */
    /* byte 2 ==============================================================*/
    unsigned char f6_pageCode       : 6;    /* Page Code                    */
    unsigned char f2_pc             : 2;    /* PC                           */
    /* byte 3 ==============================================================*/
    unsigned char subPageCode;              /* SUBPAGE CODE                 */
    /* byte 4 ==============================================================*/
    unsigned char AL;                       /* ALLOCATION LENGTH            */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__CdbModeSense10 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 5Ah )       */
    /* byte 1 ==============================================================*/
    unsigned char f3_reserved1_0    : 3;    /* reserved ( 0h )              */
    unsigned char f1_dbd            : 1;    /* DBD                          */
    unsigned char f1_llbaa          : 1;    /* LLBAA                        */
    unsigned char f3_reserved1_1    : 3;    /* reserved ( 0h )              */
    /* byte 2 ==============================================================*/
    unsigned char f6_pageCode       : 6;    /* Page Code                    */
    unsigned char f2_pc             : 2;    /* PC                           */
    /* byte 3 ==============================================================*/
    unsigned char subPageCode;              /* SUBPAGE CODE                 */
    /* byte 4 - 6 ==========================================================*/
    unsigned char reserved4_6[ 3 ];         /* reserved ( 0h )              */
    /* byte 7 - 8 ==========================================================*/
    unsigned char AL[2];                    /* Allocation Length            */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__DatMsPage {
    /* byte 0 ==============================================================*/
    unsigned char f6_pageCode       : 6;    /* Page Code                    */
    unsigned char f1_reserved0      : 1;    /* reserved ( 0h )              */
    unsigned char f1_ps             : 1;    /* PS ( 0h )                    */
    /* byte 1 ==============================================================*/
    unsigned char pageLen;                  /* Page Length ( 62h )          */
    /* byte 2 ==============================================================*/
    unsigned char f1_ac0            : 1;    /* AC0                          */
    unsigned char f1_ac1            : 1;    /* AC1                          */
    unsigned char f6_reserved2      : 6;    /* reserved ( 0h )              */
    /* byte 3 ==============================================================*/
    unsigned char f7_reserved3      : 7;    /* reserved ( 0h )              */
    unsigned char f1_sf             : 1;    /* SF                           */
    /* byte 4 - 99 =========================================================*/
    unsigned char msSystemInfo[ GSTORAGE_INFO_ATTR_SZ ]; /* MS System Information        */
};


struct _GSTORAGE_CMD__DatModeSense6 {
    /* byte 0 ==============================================================*/
    unsigned char modeDataLen;              /* Mode Data Length             */
    /* byte 1 ==============================================================*/
    unsigned char mediumType;               /* Media Type Code              */
    /* byte 2 ==============================================================*/
    unsigned char f4_reserved2      : 4;    /* reserved                     */
    unsigned char f1_dpofua         : 1;    /* DPOFUA                       */
    unsigned char f2_reserved2      : 2;    /* reserved                     */
    unsigned char f1_wp             : 1;    /* Write Protect  ON:1, OFF:0   */
    /* byte 3 ==============================================================*/
    unsigned char BDL;                      /* Block Descriptor Length      */
    /* byte 4 - 103 ========================================================*/
    union {                                 /* union : Page Parameters      */
        GSTORAGE_CMD__DatMsPage    ms;      /* for MS                       */
                                            /* PageɲûϤɲ       */
    } page;                                 /*                              */
};

struct _GSTORAGE_CMD__DatModeSense10 {
    /* byte 0 - 1 ==========================================================*/
    unsigned char modeDataLen[ 2 ];         /* Mode Data Length             */
    /* byte 2 ==============================================================*/
    unsigned char mediumType;               /* Media Type Code              */
    /* byte 3 ==============================================================*/
    unsigned char f4_reserved3      : 4;    /* reserved                     */
    unsigned char f1_dpofua         : 1;    /* DPOFUA                       */
    unsigned char f2_reserved3      : 2;    /* reserved                     */
    unsigned char f1_wp             : 1;    /* Write Protect  ON:1, OFF:0   */
    /* byte 4 ==============================================================*/
    unsigned char f1_longlba        : 1;    /* LONGLBA                      */
    unsigned char f7_reserved       : 1;    /* reserved                     */
    /* byte 5 ==============================================================*/
    unsigned char reserved5;                /* reserved                     */
    /* byte 6 - 7 ==========================================================*/
    unsigned char BDL[2];                   /* Block Descriptor Length      */
    /* byte 8 - 107 ========================================================*/
    union {                                 /* union : Page Parameters      */
        GSTORAGE_CMD__DatMsPage    ms;      /* for MS                       */
                                            /* PageɲûϤɲ       */
    } page;                                 /*                              */
};


/* Prevent / Allow Medium Removal *******************************************/
struct _GSTORAGE_CMD__CdbPreventAllow {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 1Eh )       */
    /* byte 1 - 3 ==========================================================*/
    unsigned char reserved1_3[ 3 ];         /* reserved ( 0h )              */
    /* byte 4 ==============================================================*/
    unsigned char f2_prevent        : 2;    /* Prevent                      */
    unsigned char f6_reserved4      : 6;    /* reserved ( 0h )              */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Read *********************************************************************/
struct _GSTORAGE_CMD__CdbRead6 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 08h )       */
    /* byte 1 ==============================================================*/
    unsigned char f5_LBA            : 5;    /* Logical Block Address        */
    unsigned char f3_reserved1      : 3;    /* LUN ( 0h )                   */
    /* byte 2 - 3 ==========================================================*/
    unsigned char LBA[ 2 ];                 /* Logical Block Address        */
    /* byte 4 ==========================================================*/
    unsigned char transLen;                 /* Transfer Length              */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__CdbRead10 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 28h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* Obsolete                     */
    unsigned char f1_fua_nv         : 1;    /* FUA_NV                       */
    unsigned char f1_reserved1      : 1;    /* reserved                     */
    unsigned char f1_fua            : 1;    /* FUA                          */
    unsigned char f1_dpo            : 1;    /* DPO                          */
    unsigned char f3_rdprotect      : 3;    /* RDPROTECT                    */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 ==============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f3_reserved6      : 3;    /* reserved ( 0h )              */
    /* byte 7 - 8 ==========================================================*/
    unsigned char transLen[ 2 ];            /* Transfer Length              */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__CdbRead12 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( A8h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* Obsolete                     */
    unsigned char f1_fua_nv         : 1;    /* FUA_NV                       */
    unsigned char f1_reserved1      : 1;    /* reserved                     */
    unsigned char f1_fua            : 1;    /* FUA                          */
    unsigned char f1_dpo            : 1;    /* DPO                          */
    unsigned char f3_rdprotect      : 3;    /* RDPROTECT                    */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 - 9 ==========================================================*/
    unsigned char transLen[ 4 ];            /* Transfer Length              */
    /* byte 10 =============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f1_reserved10     : 2;    /* reserved ( 0h )              */
    unsigned char f1_ristricted     : 1;    /* ristricted                   */
    /* byte 11 =============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Read Capacity ************************************************************/
struct _GSTORAGE_CMD__CdbReadCapa {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 25h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* obsolete ( 0h )              */
    unsigned char f7_reserved       : 7;    /* reserved ( 0h )              */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 - 7 ==========================================================*/
    unsigned char reserved6_7[ 2 ];         /* reserved ( 0h )              */
    /* byte 8 ==============================================================*/
    unsigned char f1_pmi            : 1;    /* PMI                          */
    unsigned char f7_reserved8      : 7;    /* reserved ( 0h )              */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__DatReadCapa {
    /* byte 0 - 3 ==========================================================*/
    unsigned char lastLBA[ 4 ];             /* Last Logical Block Address   */
    /* byte 4 - 7 ==========================================================*/
    unsigned char blockLen[ 4 ];            /* Block Length in Bytes        */
                                            /*             ( 00000200h )    */
};


/* Read Format Capacities ***************************************************/
struct _GSTORAGE_CMD__CdbReadFmtCapa {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 23h )       */
    /* byte 1 - 6 ==========================================================*/
    unsigned char reserved1_6[ 6 ];         /* reserved ( 0h )              */
    /* byte 7 - 8 ==========================================================*/
    unsigned char AL[ 2 ];                  /* Allocation Length            */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__DatReadFmtCapa {
    /* byte 0 - 2 ==========================================================*/
    unsigned char reserved0_2[ 3 ];         /* reserved ( 0h )              */
    /* byte 3 ==============================================================*/
    unsigned char capaListLen;              /* Capacity List Length ( 10h ) */
    /* byte 4 - 7 ==========================================================*/
    unsigned char curBlockNum[ 4 ];         /* Number Of Blocks             */
    /* byte 8 ==============================================================*/
    unsigned char f2_curDescript    : 2;    /* Descriptor Code              */
    unsigned char f6_reserved8      : 6;    /* reserved ( 0h )              */
    /* byte 9 - 11 =========================================================*/
    unsigned char curBlockLen[ 3 ];         /* Block Length ( 000200h )     */
    /* byte 12 - 15 ========================================================*/
    unsigned char fmtBlockNum[ 4 ];         /* Number Of Blocks             */
    /* byte 16 =============================================================*/
    unsigned char reserved16;               /* reserved ( 0h )              */
    /* byte 17 - 19 ========================================================*/
    unsigned char fmtBlockLen[ 3 ];         /* Block Length ( 000200h )     */
};


/* Request Sense ************************************************************/
struct _GSTORAGE_CMD__CdbRequestSense {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 03h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_desc           : 1;    /* DESC                         */
    unsigned char f7_reserved1      : 7;    /* reserved ( 0h )              */
    /* byte 2 - 3 ==========================================================*/
    unsigned char reserved2_3[ 2 ];         /* reserved ( 0h )              */
    /* byte 4 ==============================================================*/
    unsigned char AL;                       /* Allocation Length            */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__DatRequestSense {
    /* byte 0 ==============================================================*/
    unsigned char f7_errorCode      : 7;    /* Error Code ( 70h )           */
    unsigned char f1_valid          : 1;    /* Valid ( 0h )                 */
    /* byte 1 ==============================================================*/
    unsigned char reserved1;                /* reserved ( 0h )              */
    /* byte 2 ==============================================================*/
    unsigned char f4_senseKey       : 4;    /* Sense Key                    */
    unsigned char f1_reserved2      : 1;    /* reserved ( 0h )              */
    unsigned char f1_ili            : 1;    /* ILI                          */
    unsigned char f1_eom            : 1;    /* EOM                          */
    unsigned char f1_filemark       : 1;    /* FILEMARK                     */
    /* byte 3 - 6 ==========================================================*/
    unsigned char information[ 4 ];         /* Information ( 0h )           */
    /* byte 7 ==============================================================*/
    unsigned char addSenseLen;            /* Additional Sense Length( 0Ah ) */
    /* byte 8 - 11 =========================================================*/
    unsigned char venderSpecific[ 4 ];      /* Vender Specific ( 0h )       */
    /* byte 12 =============================================================*/
    unsigned char addSenseCode;             /* Additional Sense Code        */
    /* byte 13 =============================================================*/
    unsigned char addSenseQualifier;    /* Additional Sense Code Qualifier  */
    /* byte 14 =============================================================*/
    unsigned char fieldReplaceableUnitCode;
                                      /* Field Replaceable Unit Code ( 0h ) */
    /* byte 15 =============================================================*/
    unsigned char f7_reserved15     : 7;    /* reserved ( 0h )              */
    unsigned char f1_sksv           : 1;    /* SKSV ( 0h )                  */
    /* byte 16 - 17 ========================================================*/
    unsigned char progress[ 2 ];            /* Progress Indication ( 0h )   */
};

struct _GSTORAGE_CMD__DatRequestSenseDvd {
    /* byte 0 ==============================================================*/
    unsigned char f7_errorCode      : 7;    /* Error Code ( 70h or 71h )    */
    unsigned char f1_valid          : 1;    /* Valid                        */
    /* byte 1 ==============================================================*/
    unsigned char segmentNum;               /* Segment Number ( Reserved )  */
    /* byte 2 ==============================================================*/
    unsigned char f4_senseKey       : 4;    /* Sense Key                    */
    unsigned char f1_reserved2      : 1;    /* reserved                     */
    unsigned char f1_ili            : 1;    /* ILI                          */
    unsigned char f2_reserved2      : 2;    /* reserved                     */
    /* byte 3 - 6 ==========================================================*/
    unsigned char information[ 4 ];         /* Information                  */
    /* byte 7 ==============================================================*/
    unsigned char addSenseLen;          /* Additional Sense Length ( n-7 )  */
    /* byte 8 - 11 =========================================================*/
    unsigned char commandSpecific[ 4 ];     /* Command Specific Information */
    /* byte 12 =============================================================*/
    unsigned char addSenseCode;             /* Additional Sense Code        */
    /* byte 13 =============================================================*/
    unsigned char addSenseQualifier;    /* Additional Sense Code Qualifier  */
    /* byte 14 =============================================================*/
    unsigned char fieldReplaceableUnitCode; /* Field Replaceable Unit Code  */
    /* byte 15 - 17 ========================================================*/
    unsigned char senseKeySpecific[ 3 ];    /* Sense Key Specific           */
    /* byte 18 - 63 ========================================================*/
    unsigned char addSenseBytes[ 46 ];      /* Additional Sense Bytes       */
};


/* Seek *********************************************************************/
struct _GSTORAGE_CMD__CdbSeek {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 2Bh )       */
    /* byte 1 ==============================================================*/
    unsigned char f5_reserved1      : 5;    /* reserved ( 0h )              */
    unsigned char f3_lun            : 3;    /* LUN ( 0h )                   */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 - 11 =========================================================*/
    unsigned char reserved6_11[ 6 ];        /* reserved ( 0h )              */
};


/* Start Stop ***************************************************************/
struct _GSTORAGE_CMD__CdbStartStop {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 1Bh )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_immed          : 1;    /* Immed ( 0h / 1h )            */
    unsigned char f7_reserved1      : 7;    /* reserved ( 0h )              */
    /* byte 2 - 3 ==========================================================*/
    unsigned char reserved2_3[ 2 ];         /* reserved ( 0h )              */
    /* byte 4 ==============================================================*/
    unsigned char f1_start          : 1;    /* Start                        */
    unsigned char f1_loEj           : 1;    /* LoEj                         */
    unsigned char f2_reserved4      : 2;    /* reserved ( 0h )              */
    unsigned char f4_power_condition : 4;   /* POWER CONDITION              */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Synchronize Cache ********************************************************/
struct _GSTORAGE_CMD__CdbSynchronizeCache {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 35h )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* obsolete ( 0h )              */
    unsigned char f1_immed          : 1;    /* IMMED                        */
    unsigned char f1_sync_nv        : 1;    /* SYNC_NV                      */
    unsigned char f5_reserved       : 5;    /* reserved ( 0h )              */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 ==============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f3_reserved6      : 3;    /* reserved ( 0h )              */
    /* byte 7 - 8 ==========================================================*/
    unsigned char numberOfBlocks[ 2 ];      /* reserved ( 0h )              */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Test Unit Ready **********************************************************/
struct _GSTORAGE_CMD__CdbTestUnit {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 00h )       */
    /* byte 1 - 4 =========================================================*/
    unsigned char reserved1_4[ 4 ];         /* reserved ( 0h )              */
    /* byte 5 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete5      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved5      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Verify *******************************************************************/
struct _GSTORAGE_CMD__CdbVerify {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 2Fh )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* obsolete                     */
    unsigned char f1_byteChk        : 1;    /* ByteChk                      */
    unsigned char f2_reserved1      : 2;    /* reserved ( 0h )              */
    unsigned char f1_dpo            : 1;    /* DPO                          */
    unsigned char f3_vrprotect      : 3;    /* vrprotect                    */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 ==============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f2_reserved6      : 2;    /* reserved ( 0h )              */
    unsigned char f1_reistricted    : 1;    /* Restricted for MMC-4         */
    /* byte 7 - 8 ==========================================================*/
    unsigned char verifyLen[ 2 ];           /* Verification Length          */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};


/* Write ********************************************************************/
struct _GSTORAGE_CMD__CdbWrite10 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( 2Ah )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* Obsolete                     */
    unsigned char f1_fua_nv         : 1;    /* FUA_NV                       */
    unsigned char f1_reserved1      : 1;    /* reserved                     */
    unsigned char f1_fua            : 1;    /* FUA                          */
    unsigned char f1_dpo            : 1;    /* DPO                          */
    unsigned char f3_wrprotect      : 3;    /* WRPROTECT                    */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 ==============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f3_reserved6      : 3;    /* reserved ( 0h )              */
    /* byte 7 - 8 ==========================================================*/
    unsigned char transLen[ 2 ];            /* Transfer Length              */
    /* byte 9 ==============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

struct _GSTORAGE_CMD__CdbWrite12 {
    /* byte 0 ==============================================================*/
    unsigned char OpCode;                   /* Operation Code ( AAh )       */
    /* byte 1 ==============================================================*/
    unsigned char f1_obsolete1      : 1;    /* Obsolete                     */
    unsigned char f1_fua_nv         : 1;    /* FUA_NV                       */
    unsigned char f1_reserved1      : 1;    /* reserved                     */
    unsigned char f1_fua            : 1;    /* FUA                          */
    unsigned char f1_dpo            : 1;    /* DPO                          */
    unsigned char f3_wrprotect      : 3;    /* WRPROTECT                    */
    /* byte 2 - 5 ==========================================================*/
    unsigned char LBA[ 4 ];                 /* Logical Block Address        */
    /* byte 6 - 9 ==========================================================*/
    unsigned char transLen[ 4 ];            /* Transfer Length              */
    /* byte 10 =============================================================*/
    unsigned char f5_group_number   : 5;    /* GROUP NUMBER                 */
    unsigned char f2_reserved10     : 2;    /* reserved ( 0h )              */
    unsigned char f1_reistricted    : 1;    /* Restricted for MMC-4         */
    /* byte 11 =============================================================*/
    unsigned char f1_link           : 1;    /* LINK                         */
    unsigned char f1_obsolete9      : 1;    /* Obsolote ( 0h )              */
    unsigned char f1_naca           : 1;    /* NACA                         */
    unsigned char f3_reserved9      : 3;    /* reserved ( 0h )              */
    unsigned char f2_vendor         : 2;    /* vendor                       */
};

/*

 饹                                                           
*/

/*

 ؿ                                                         
*/

#endif  /*__USBG_STORAGE_CMD_H__*/

