/*
 * usbg_storage_debug.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2010 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Debug Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_DEBUG_H__
#define __USBG_STORAGE_DEBUG_H__

#include <linux/kernel.h>
#include "usbg_storage_conf.h"

#define USBG_DBGP_ON

/****************************************/
/* error Lv. ID                         */
/****************************************/
enum {
    GS_LV__ERR = 0x00,
    GS_LV__WAR,
    GS_LV__INF,
    GS_LV__DBG,
    GS_LV__DET,
};

/************************************************************************************/
/* for Debug Print                                                                  */
/************************************************************************************/
/* DEBUG TEST TYPE */
#define GS_OUT__NOTHING              0x00				/* output  :: nothing                   */
#define GS_OUT__PRINTK               0x01				/* output  :: printk                    */

#define GS_OUT__MBF                  GS_OUT__NOTHING	/* mbf     :: message buffer            */
#define GS_OUT__MBF_QUEUE_NUM        GS_OUT__NOTHING	/* mbf     :: check message queue num   */
#define GS_OUT__BDIO                 GS_OUT__NOTHING	/* bdio    :: block device I/O          */
#define GS_OUT__CMN                  GS_OUT__PRINTK		/* cmn     :: init/exit, open/release   */

#define GS_OUT__PROBE                GS_OUT__PRINTK		/* svc     :: ioctl (probe)             */
#define GS_OUT__REMOVE               GS_OUT__PRINTK		/* svc     :: ioctl (remove)            */
#define GS_OUT__INIT_INFO            GS_OUT__PRINTK		/* svc     :: ioctl (set init info)     */
#define GS_OUT__MEDIA_STATUS         GS_OUT__PRINTK		/* svc     :: set media status          */
#define GS_OUT__EXTCOMMAND           GS_OUT__PRINTK		/* svc     :: ext command               */

#define GS_OUT__DAEMONIZE            GS_OUT__NOTHING	/* check   :: daemonize(put pid)        */
#define GS_OUT__BUFLEN_16K           GS_OUT__NOTHING	/* check   :: buflen 16KB test          */
#define GS_OUT__BUFLEN_32K           GS_OUT__NOTHING	/* check   :: buflen 32KB test          */
#define GS_OUT__GET_LOG              GS_OUT__NOTHING	/* check   :: get status log            */

#define GS_OUT__START                GS_OUT__PRINTK		/* core    :: core start                */
#define GS_OUT__STOP                 GS_OUT__PRINTK		/* core    :: core stop                 */
#define GS_OUT__CLASS                GS_OUT__PRINTK		/* core    :: class request             */
#define GS_OUT__SET_HALT             GS_OUT__PRINTK		/* core    :: set halt                  */
#define GS_OUT__CLEAR_HALT           GS_OUT__PRINTK		/* core    :: clear halt                */
#define GS_OUT__USB_EP_QUEUE         GS_OUT__PRINTK		/* core    :: usb_ep_queue              */
#define GS_OUT__USB_EP_QUEUE_DIS     GS_OUT__PRINTK		/* core    :: usb_ep_queue disable      */

#define GS_OUT__MAINCNT              GS_OUT__PRINTK		/* maincnt :: main controller sequence  */
#define GS_OUT__NEXT_STATUS          GS_OUT__NOTHING	/* maincnt :: next status               */
#define GS_OUT__TIMER                GS_OUT__PRINTK		/* maincnt :: timer                     */
#define GS_OUT__RESET_RECOVERY       GS_OUT__PRINTK		/* maincnt :: reset recovery            */

#define GS_OUT__DRVCNT               GS_OUT__PRINTK		/* drvcnt  :: drive controller sequence */
#define GS_OUT__CTX                  GS_OUT__PRINTK		/* drvcnt  :: drive context             */

#define GS_OUT__CMD_STD              GS_OUT__PRINTK		/* cmd     :: command (std)             */
#define GS_OUT__CMD_DVD              GS_OUT__PRINTK		/* cmd     :: command (dvd)             */
#define GS_OUT__CMD_HARD             GS_OUT__PRINTK		/* cmd     :: command (hard)            */
#define GS_OUT__CMD_RW               GS_OUT__PRINTK		/* cmd     :: command (read/write)      */

#define GS_INT__START                0xFF				/* id      :: interrupt ID (for debug)  */
#define GS_INT__STOP                 0xFE				/* id      :: interrupt ID (for debug)  */
#define GS_INT__SET_HALT             0xFD				/* id      :: interrupt ID (for debug)  */
#define GS_INT__CLEAR_HALT           0xFC				/* id      :: interrupt ID (for debug)  */
#define GS_INT__STORAGE_RESET        0xFB				/* id      :: interrupt ID (for debug)  */
#define GS_INT__GET_MAX_LUN          0xFA				/* id      :: interrupt ID (for debug)  */

#define MAX_LOG_CNT                  10000


/* make ˻꤬ʤ 2  */
#ifndef USBG_STORAGE_DEBUG_LEVEL
#define USBG_STORAGE_DEBUG_LEVEL 2
#endif

/************************************************************************/
/* Debug Print : ON                                                     */
/************************************************************************/
#if defined USBG_DBGP_ON
/* GS_ERR ==============================================================*/
#if USBG_STORAGE_DEBUG_LEVEL > 0
#define GS_ERR( id, fmt, args...){                                      \
    printk( "ERR [%s:L%d]%s() :: "fmt"\n",                              \
            MY_NAME, __LINE__, __FUNCTION__, ##args );                  \
}
#else
#define GS_ERR( fmt, args...){}
#endif
/* GS_WAR ==============================================================*/
#if USBG_STORAGE_DEBUG_LEVEL > 1
#define GS_WAR( id, fmt, args...){                                      \
    printk( "WAR [%s:L%d]%s() :: "fmt"\n",                              \
            MY_NAME, __LINE__, __FUNCTION__, ##args );                  \
}
#else
#define GS_WAR( fmt, args...){}
#endif
/* GS_INF ==============================================================*/
#if USBG_STORAGE_DEBUG_LEVEL > 2
#define GS_INF( id, fmt, args...){                                      \
    if ( id >= GS_OUT__PRINTK ){                                        \
        printk( "INF [%s:L%d]%s() :: "fmt"\n",                          \
                MY_NAME, __LINE__, __FUNCTION__, ##args );              \
    }                                                                   \
}
#else
#define GS_INF( fmt, args...){}
#endif
/* GS_DBG ==============================================================*/
#if USBG_STORAGE_DEBUG_LEVEL > 3
#define GS_DBG( id, fmt, args...){                                      \
    if ( id >= GS_OUT__PRINTK ){                                        \
        printk( "DBG [%s:L%d]%s() :: "fmt"\n",                          \
                MY_NAME, __LINE__, __FUNCTION__, ##args );              \
    }                                                                   \
}
#else
#define GS_DBG( fmt, args...){}
#endif
/* GS_DET ==============================================================*/
#if USBG_STORAGE_DEBUG_LEVEL > 4
#define GS_DET( id, fmt, args...){                                      \
    if ( id >= GS_OUT__PRINTK ){                                        \
        printk( "DET [%s:L%d]%s() :: "fmt"\n",                          \
                MY_NAME, __LINE__, __FUNCTION__, ##args );              \
    }                                                                   \
}
#else
#define GS_DET( fmt, args...){}
#endif

/************************************************************************/
/* Debug Print : OFF                                                    */
/************************************************************************/
#else
#define GS_ERR( id, fmt, args...){}                    /* GS_ERR   */
#define GS_WAR( id, fmt, args...){}                    /* GS_WAR   */
#define GS_INF( id, fmt, args...){}                    /* GS_INF   */
#define GS_DBG( id, fmt, args...){}                    /* GS_DBG   */
#define GS_DET( id, fmt, args...){}                    /* GS_DET   */
#endif

#endif /* __USBG_STORAGE_DEBUG_H__ */

