/*
 * usbg_storage_maincnt.h
 *
 * USB Mass Storage Gadget Function Driver
 *
 * Copyright 2005,2006,2011 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * << MassStorage Gadget Main Controller Header >>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef __USBG_STORAGE_MAINCNT_H__	    /* ť󥯥롼ɥ顼ɻ */
#define __USBG_STORAGE_MAINCNT_H__
/*

 󥯥롼ɥե                                                 
*/
#include <linux/timer.h>
#include "usbg_storage_conf.h"

/*

                                                              
*/
#define GSTORAGE__WAIT_SEC  100 * 1	/* 1 sec */

/*

                                                                
*/
typedef struct {
    /* Svc -> Cmn ͳǼ */
    signed int    maxLun;                       /* LUN              */
    unsigned char *pCbwBuf;                     /* CBWѥХåե        */
    unsigned char *pCswBuf;                     /* CSWѥХåե        */
    /* EP ¤ */
    struct usb_ep *p_ep[ GSTORAGE_EP_NUM ];     /* EP               */
    /* PACKET ޥɤΥǡ¤ */
    GSTORAGE__Packet *pPckt;                    /* Τ init ˳ */
    /* CBW */
    unsigned int rcvLenOnCbw;
    /* EP QUEUE Ƚѥե饰 */
    unsigned char disEpQueue;                   /* OFF:ġON:        */
    /*  */
    unsigned char     waitTimer;
    struct timer_list timer;
    /* Unknown Media ̵ͭ  */
    unsigned char unknownMedia;                 /* OFF:̵ON:ͭ        */
    
    /* STALL Info of pipes. ONLY USE when MassStorage Reset */
    unsigned char is_bulk_in_stalled;           /* Bulk-IN  -> 1:now STALL. 0:not STALL */
    unsigned char is_bulk_out_stalled;          /* Bulk-OUT -> 1:now STALL. 0:not STALL */
    
} GSTORAGE_MainContext;

typedef struct {
    unsigned int state;
    unsigned int msg;
} statusLog;


/*

 饹                                                           
*/

/*

 ؿ                                                         
*/
/* MassStorage  */
extern void storage_probeMassStorage( void );
/* MassStorage λ */
extern void storage_reqRemoveMassStorage( void );
/* ǥХϿ */
extern int storage_maincnt_setInitInfo( GSTORAGE__InfoInitMain * );
/* ǥХκ */
extern void storage_maincnt_clearInitInfo( void );
/* Core Start ׵ */
extern void storage_maincnt_reqStart( void );
/* Core Stop ׵ */
extern void storage_maincnt_reqStop( void );
/* Set Media Status ׵ */
extern void storage_maincnt_reqSetMediaStatus( GSTORAGE__InfoMediaStatus * );
/* MassStorage Reset λ */
extern void storage_maincnt_compMassStorageReset( void );
/* Reset Recovery λ */
extern void storage_maincnt_compResetRecovery( void );
/* EP Clear Halt */
extern void storage_maincnt_epClearHalt( struct usb_ep * );
/* Thread  */
extern int storage_maincnt_allocThread( void );
/* Thread  */
extern void storage_maincnt_freeThread( void );
/* Thread Ʊ¤μ */
extern GSTORAGE__Thread *storage_maincnt_getThread( void );
/* EP get */
extern struct usb_ep *storage_maincnt_getEp( int );
/* EP set */
extern void storage_maincnt_setEp( struct usb_ep *, int );
/* EP clear */
extern void storage_maincnt_clearEp( void );
/* put message for usb_ep_queue() error */
extern void error_ep_request_put_message( int );
/* set status log */
extern void set_log_data( unsigned int, unsigned int );
/* put status log */
extern void put_log_data( void );

/*

 ѿ                                                         
*/

#endif/*__USBG_STORAGE_MAINCNT_H__*/

