/*
 * Copyright 2005,2006 Sony Corporation
 * Copyright 2018 Sony Imaging Products and Solutions Incorporated.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __UAPI_USBD_TYPE_H__
#define __UAPI_USBD_TYPE_H__

#include <linux/usb/gcore/usb_event.h>

/*  */
/* ͥ륤٥ȷ							*/
/*  */
enum {
    USBG_KEVENT_ID_CMN_START = 0,
    USBG_KEVENT_ID_CMN_STOP,
    USBG_KEVENT_ID_CMN_EP_SET_HALT,
    USBG_KEVENT_ID_CMN_EP_CLR_HALT,
    USBG_KEVENT_ID_CMN_SUSPEND,
    USBG_KEVENT_ID_CMN_RESUME,
    USBG_KEVENT_ID_CMN_CLASS,
    USBG_KEVENT_ID_CMN_VENDOR,
    USBG_KEVENT_ID_CMN_WRITE_CMP,
    USBG_KEVENT_ID_CMN_NBROF,
};

/*  */
/* ͥ륤٥ȥѥ᡼						*/
/*  */
struct usbg_kevent_arg_cmn_start {
};

struct usbg_kevent_arg_cmn_stop {
};

struct usbg_kevent_arg_cmn_ep_set_hlt {
};

struct usbg_kevent_arg_cmn_ep_clr_hlt {
};

struct usbg_kevent_arg_cmn_suspend {
};

struct usbg_kevent_arg_cmn_resume {
};

struct usbg_kevent_arg_cmn_class {
};

struct usbg_kevent_arg_cmn_vendor {
};


/*  */
/* ͥ륤٥ȥХå					*/
/*  */
struct func_info_event {
    void (*start)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*stop)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*ep_set_halt)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*ep_clear_halt)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*suspend)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*resume)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*class_req)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
    void (*vendor_req)
        ( unsigned long hndl, unsigned char id,
          unsigned char uc_arg_sz, void* vp_arg );
};

/*  */
/* Svc->Function probe						*/
/* 	ServiceϤ						*/
/*  */
struct func_info_interface {
    char uc_configuration;	/* Configuration			*/
    char uc_interface;		/* Interface				*/
};

struct probe_info {
    usb_hndl_t hndl;		/* Svcϥɥ			*/
    struct func_info_event event;	/* ٥ȥХå		*/
    struct func_info_interface* tbl_interface;
    struct func_info_interface* extended_tbl_interface;
    bool HasExtendedTblIf;
    unsigned char uc_func_info_interface_num;
    void *vp_user;			/* ĥ				*/
    uint32_t ul_user_size;
};

#endif
