#===============================================================
# 各種make変数をリセットします。必ず先頭行に記述してください。
# また、この記述は削除しないでください。
#===============================================================
include $(CLEAR_VARS_USERSPACE)

#===============================================================
INSTALL_USER_PATH := /usr/lib/
#===============================================================

#===============================================================
# 生成ファイル名をセットします。必ず1つだけ指定してください。
# 複数のファイル名は指定できません。
#===============================================================
TARGET   := librtmp.so.0

#===============================================================
# ビルド対象の他のディレクトリがあれば記述してください。
# ほとんどの場合は下層のディレクトリを指定します。
# 複数のディレクトリがある場合は2つ目以降のディレクトリを
# SUBDIRS += xxx で記述してください。
# 例：
# SUBDIRS := dir_a
# SUBDIRS += dir_b
#===============================================================

#===============================================================
# ヘッダ参照パスをセットします。パスの前に-Iを記述してください。
# パス中のリポジトリ名は変数名を記述してください。
# リポジトリ名を直接記述しないでください。
# 複数のパスがある場合は2つ目以降のパスを
# EXPORTS += -Ixxx で記述してください。
# 例：
# EXPORTS := -Ipath_a
# EXPORTS += -Ipath_b
#===============================================================
EXPORTS	+= -I $(VOB_OSAL_ULOGIO)/export
EXPORTS	+= -I $(VOB_OSAL_UIPC)/export
EXPORTS += -I $(VOB_NET_INFRA_STREAM)/export
EXPORTS += -I $(VOB_NET_INFRA_STREAM)/userspace/Infra/InfraRtmpLiveStreaming
EXPORTS += -I $(VOB_NET_INFRA_STREAM)/userspace/Infra/InfraRtmpLiveStreaming/gstreamer/plugin/livestream/
EXPORTS += -I $(VOB_AVMOVIECODEC)/export/

#===============================================================
# コンパイル対象のファイルをセットします。
# SUBDIRSも同時に設定されている場合はSUBDIRSで指定された
# ディレクトリが先にビルドされます。
# 複数ファイルある場合は2つ目以降のパスを
# SRCS += xxx で記述してください。
# 例：
# SRCS := aaa.c
# SRCS += bbb.c
#===============================================================
SRCS    := 
SRCS    += rtmp.c
SRCS    += log.c
SRCS    += amf.c
SRCS    += hashswf.c
SRCS    += parseurl.c

#===============================================================
# リンク対象またはアーカイブ対象のオブジェクトがあれば記述してください。
# 下位ディレクトリの*.oや*.aを指定するのが一般的です。
# 他リポジトリで動的に生成される*.oや*.aは絶対に指定しないでください。
# ビルド順番の依存ができてしまいパラレルビルドができなくなります。
# このような場合は、他リポジトリの*.oや*.aはバイナリリリースにしてください。
# それでも難しい場合はモジュール構成を見直してください。
# 複数のオブジェクトがある場合は2つ目以降のパスを
# LIBS += xxx で記述してください。
# 例：
# LIBS := dir_a/aaa.o
# LIBS += dir_b/bbbb.a
#===============================================================
# For RTMPS
CRYPTO=OPENSSL

DEF_=-DNO_CRYPTO
DEF_OPENSSL=-DUSE_OPENSSL
CRYPTO_DEF=$(DEF_$(CRYPTO))

LIBZ=-lz
LIB_=
LIB_OPENSSL=-lssl -lcrypto $(LIBZ)
CRYPTO_LIB=$(LIB_$(CRYPTO))

#===============================================================
# *.cファイルのコンパイル時オプションをセットしてください。
# 複数のオプションがある場合は2つ目以降のパスを
# CFLAGS += xxx で記述してください。
# 例：
# CFLAGS := xxx
# CFLAGS += yyy
#===============================================================
CFLAGS :=
CFLAGS  += -g -fPIC -DRTMPDUMP_VERSION=\"$(VERSION)\" $(CRYPTO_DEF)
LDFLAGS += -shared -Wl,-soname,librtmp.so.0 $(CRYPTO_LIB)

#===============================================================
# *.cppファイルのコンパイル時オプションをセットしてください。
# 複数のオプションがある場合は2つ目以降のパスを
# CXXFLAGS += xxx で記述してください。
# 例：
# CXXFLAGS := xxx
# CXXFLAGS += yyy
#===============================================================
CXXFLAGS :=

#===============================================================
# ビルド対象に応じて1つだけ有効にしてください。
#
# $(BUILD_RULE_HOST_USERSPACE)
#	SSITEM_MainLSIのuserspace空間で動作するオブジェクトをビルドする場合。
#
# $(BUILD_RULE_HOST_DRIVER)
#	SSITEM_MainLSIのdriverをビルドする場合。
#
# $(BUILD_RULE_LIRO)
#	LIROの構成モジュールをビルドする場合。
#
# $(BUILD_RULE_PROISP)
#	proispの構成モジュールをビルドする場合。
#===============================================================
include	$(BUILD_RULE_HOST_USERSPACE)
#include	$(BUILD_RULE_HOST_DRIVER)
#include	$(BUILD_RULE_LIRO)
#include	$(BUILD_RULE_PROISP)

#===============================================================
# 独自のターゲットを定義する場合はorijinal.mkのファイル名で作成し、
# 以下のコメントを外して有効にしてください。
#===============================================================
#include	$(BUILD_RULE_ORIJINAL)


