
/*
 * arch/arm/include/asm/unwind_internal.h
 *
 * Copyright (C) 2008 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __ASM_UNWIND_INTERNAL_H
#define __ASM_UNWIND_INTERNAL_H

#include <linux/uaccess.h>

struct unwind_ctrl_block {
	unsigned long vrs[16];		/* virtual register set */
	const unsigned long *insn;	/* pointer to the current instructions word */
	unsigned long sp_high;          /* highest value of sp allowed */
	/*
	 * 1 : check for stack overflow for each register pop.
	 * 0 : save overhead if there is plenty of stack remaining.
	 */
	int check_each_pop;
	int entries;			/* number of entries left to interpret */
	int byte;			/* current byte number in the instructions word */
};

extern int unwind_frame(struct stackframe *frame);

static inline unsigned long bt_get_user32(const unsigned long *addr)
{
	unsigned long __user data;
	register unsigned int current_pc;
	asm("mov %0, pc" : "=r"(current_pc));

	if (copy_from_user(&data, addr, sizeof(unsigned long))) {
		/* data is set to zero */
		printk("bt_get_user32: illegal address %p pc:%x ra:%p\n", addr, current_pc, __builtin_return_address(0));
	}
	return data;
}

static inline void bt_put_user32(unsigned long *to, unsigned long *from)
{

	if (copy_to_user(to, from, sizeof(unsigned long))) {
		printk("bt_put_user32: illegal address %p %p\n",to, from);
	}
}

#endif  /* __ASM_UNWIND_INTERNAL_H */
