/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Based on arch/arm/include/asm/proc-fns.h
 *
 * Copyright (C) 1997-1999 Russell King
 * Copyright (C) 2000 Deep Blue Solutions Ltd
 * Copyright (C) 2012 ARM Ltd.
 */
#ifndef __ASM_PROCFNS_H
#define __ASM_PROCFNS_H

#ifndef __ASSEMBLY__

#include <asm/page.h>

struct cpu_suspend_ctx;

extern void cpu_do_idle(void);
extern void cpu_do_suspend(struct cpu_suspend_ctx *ptr);
extern u64 cpu_do_resume(phys_addr_t ptr, u64 idmap_ttbr);
#ifdef CONFIG_HOTPLUG_CPU
extern void cpu_enter_lowpower(void);
extern void cpu_leave_lowpower(void);
#endif /* CONFIG_HOTPLUG_CPU */

#include <asm/memory.h>

#endif /* __ASSEMBLY__ */
#endif /* __ASM_PROCFNS_H */
