/*
 *  arch/arm64/kernel/kemco.c
 *
 *  Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/string.h>
#include <linux/io.h>
#include <asm/setup.h>

#define PA_CMDLINE _AC(CONFIG_CMDLINE_PHYS_OFFSET, UL)

#define MAGIC "kemco"

void __init setup_kemco(void)
{
	char *s;

	s = early_memremap(PA_CMDLINE, COMMAND_LINE_SIZE);
	if (!s) {
		printk(KERN_ERR "%s: early_memremap failed\n", __func__);
		return;
	}

	if (!strncmp(MAGIC, s, strlen(MAGIC))){
		char *from = s + strlen(MAGIC);
		char *p;
		int n;

		printk(KERN_INFO "cmdline override at 0x%lx\n", PA_CMDLINE);
		/* replace '\n' to ' ' */
		p = from;
		n = COMMAND_LINE_SIZE;
		while (0 < n  &&  '\0' != *p) {
			if ('\n' == *p || '\r' == *p) {
				*p = ' ';
				if (1 < n  &&  '*' == p[1]) { /* terminator? */
					*p = '\0';
					break;
				}
			}
			p++;
			n--;
		}
		strlcpy(boot_command_line, from, COMMAND_LINE_SIZE);
	} else {
		printk(KERN_ERR "invalid cmdline override @ 0x%lx. Using default cmdline.\n", PA_CMDLINE);
	}

	early_memunmap(s, COMMAND_LINE_SIZE);
}
