/*
 * block/partitions/sdm2.c
 *
 * SDM partiton table handler
 *
 * Copyright 2018 Sony Corporation
 *
 * This code is based on block/partitions/sun.c
 */
/*
 *  fs/partitions/sun.c
 *
 *  Code extracted from drivers/block/genhd.c
 *
 *  Copyright (C) 1991-1998  Linus Torvalds
 *  Re-organised Feb 1998 Russell King
 */

#include "check.h"
#include "sdm2_partition_table.h"

int
sdm2_partition(struct parsed_partitions *state)
{
	struct gendisk *disk = state->disk;
	struct block_device *bdev;
	int i, limit;
	Sector sector;
	unsigned int n_sectors;
	sdm_partition_tbl *label;
	struct sdm_partition *p;

	if (!disk || !disk->part0)
		return 0;
	bdev = disk->part0;
	n_sectors = i_size_read(bdev->bd_inode) >> SECTOR_SHIFT;
	if ((label = (void *)read_part_sector(state, 0, &sector)) == NULL)
		return -1;
	if (label->magic != SDM_LABEL_MAGIC
	    || label->version != SDM_LABEL_VERSION
	    || label->n_partition > SDM_LABEL_N_PARTITION){
		put_dev_sector(sector);
		return 0;
	}
	limit = label->n_partition + 1;
	if (limit > state->limit)
		limit = state->limit;
	for (i = 1, p = label->partitions; i < limit; i++, p++){
		if (!(p->flag & SDM_LABEL_VALID) ||  p->size == 0)
			continue;
		if (p->start >= n_sectors)
			continue;
		if (p->size > n_sectors)
			continue;
		if (p->start + p->size > n_sectors)
			continue;
		put_partition(state, i, p->start, p->size);
	}
	put_dev_sector(sector);
	printk("\n");

	return 1;
}
