/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright 2022 Sony Corporation, SOCIONEXT INC.
 *
 */
#ifndef CLK_LIN_H
#define CLK_LIN_H

#define C_CLK_HD_IN27	(27 * 1000 * 1000)
#define C_CLK_HD_IN72	(24 * 1000 * 1000)		// 72MHz/3 = 24MHz
#define C_CLK_SYS_IN	(24 * 1000 * 1000)
#define M_CLK_USB_IN	(24 * 1000 * 1000)

#define C_CLK_IN	"c_clk_in"
#define M_CLK_IN	"m_clk_in"

#define DIV_REG		0
#define GATE_REG	1
#define MUX_REG		2
#define MAX_REG		3

#define GCRG0		0
#define GCRG(n)		(GCRG0 + 0x1000 * (n))
#define GCRGPLLFREQ1	0x0
#define  PLLFDIV_MASK	0xff
#define GCRGPLLFREQ2	0x4
#define  PLLFDEN_SHIFT	16
#define  PLLFDEN_MASK	0xffff
#define  PLLFNUM_MASK	0xffff
#define GCRGODIVCH0	0x40
#define GCRGODIVCH(n)	(GCRGODIVCH0 + 0x04 * (n))
#define  ODIVCHNUM_MASK	0xff
#define GCRGCMDEN	0x80
#define  CMDNOP		0
#define  CMDOCLK	2

#define LCRG0		0x1f000
#define LCRG(n)		(LCRG0 + 0x1000 * (n))
#define LCRUPC		0xc
#define  UPC_RUNNING	1
#define  UPC_NOT_RUNNING	0
#define LCRCOC0		0x10
#define LCRCOC(n)	(LCRCOC0 + 0x4 * (n))
#define  LDIVRC_MASK	7

#define GCBCNT0		0x0
#define GCBCNT(n)	(GCBCNT0 + 0x10 * (n))

#define CLKSEL1		0x10
#define  CLK27_24_MASK	BIT(17)
#define  CLK72_27_MASK	BIT(16)

#define SET_REG		4
#define CLR_REG		8

#define POLL_TIMEOUT_US		1
#define POLL_INTERVAL_US	0

#define NUMBER_OF_GCRG_INSTANCE		21
#define NUMBER_OF_XCRG_INSTANCE		0x30
#define NUMBER_OF_XCRG_DIVIDER		21 // MAX at LCRG_L2
#define NUMBER_OF_GCBCNT_REGS		34
#define NUMBER_OF_MUX_REGS		2

#ifdef CONFIG_CLOCK_FPGA_ENV
#define DIV_CH_OFS_GCRG		0x40
#define DIV_CH_OFS_LCRG		0x10
#define DIV_CH_MASK		0xff
#define DIV_CH_SHIFT		2
#define GATE_SHIFT		4
#define GATE_MASK		0x3f
#define MUX_SHIFT		4
#define MUX_MASK		0x1
#endif

struct lin_clk_fixed_factor_data {
	const char *name;
	const char *parent_name;
	int idx;
	u32 mult;
	u32 div;
};

struct lin_clk_pll_data {
	const char *name;
	const char *parent_name;
	int gcrg_id;
};

struct lin_clk_fixed_rate_data {
	const char *name;
	int idx;
	unsigned long fixed_rate;
};

struct lin_clk_div_data {
	const char *name;
	const char *parent_name;
	int idx;
	u32 reg;
	u32 bit;
	u32 width;
	u8 div_flag;
};

struct lin_clk_mux_data {
	const char *name;
	const char *parent_names[3];
	int idx;
	u32 num_parents;
	u32 reg;
	u32 mask;
	u8 shift;
};

struct lin_clk_gate_data {
	const char *name;
	const char *parent_name;
	int idx;
	u32 reg;
	u32 bit;
};

#define LIN_CLK_PLL(_name, _parent, _gcrg_id)			\
	{							\
		.name = (_name),				\
		.parent_name = (_parent),			\
		.gcrg_id = (_gcrg_id),				\
	}

#define LIN_CLK_FACTOR(_name, _idx, _parent, _mult, _div)	\
	{							\
		.name = (_name),				\
		.idx = (_idx),					\
		.parent_name = (_parent),			\
		.mult = (_mult),				\
		.div = (_div),					\
	}

#define LIN_CLK_RATE(_name, _idx, _rate)			\
	{							\
		.name = (_name),				\
		.idx = (_idx),					\
		.fixed_rate = (_rate),				\
	}

#define LIN_CLK_DIV(_name, _idx, _parent, _reg, _bit, _width, _ro)	\
	{								\
		.name = (_name),					\
		.idx = (_idx),						\
		.parent_name = (_parent),				\
		.reg = (_reg),						\
		.bit = (_bit),						\
		.width = (_width),					\
		.div_flag = (_ro),					\
	}

#define LIN_CLK_DIV_GCRG(_name, _idx, _parent, _xcrg_id,		\
	_ch, _ro)							\
	LIN_CLK_DIV(_name, _idx, _parent,				\
	(GCRG(_xcrg_id) + GCRGODIVCH(_ch)), 0, 8, _ro)

#define LIN_CLK_DIV_LCRG(_name, _idx, _parent, _xcrg_id,		\
	_ch, _ro)							\
	LIN_CLK_DIV(_name, _idx, _parent,				\
	LCRG(_xcrg_id) + LCRCOC(_ch), 0, 3,				\
	CLK_DIVIDER_POWER_OF_TWO | (_ro))

#define LIN_CLK_MUX(_name, _idx, _pname0, _pname1, _pname2, _shift)	\
	{								\
		.name = (_name),					\
		.idx = (_idx),						\
		.parent_names = {					\
			(_pname0),					\
			(_pname1),					\
			(_pname2),					\
		},							\
		.num_parents = 3,					\
		.reg = CLKSEL1,						\
		.mask = 3,						\
		.shift = _shift,					\
	}

#define LIN_CLK_MUX_UHS1(_name, _idx, _pname0, _pname1, _pname2)	\
	LIN_CLK_MUX(_name, _idx, _pname0, _pname1, _pname2, 0)

#define LIN_CLK_MUX_EMMC(_name, _idx, _pname0, _pname1, _pname2)	\
	LIN_CLK_MUX(_name, _idx, _pname0, _pname1, _pname2, 2)

#define LIN_CLK_GATE(_name, _idx, _parent, _gcbcnt, _bit)	\
	{							\
		.name = (_name),				\
		.idx = (_idx),					\
		.parent_name = (_parent),			\
		.reg = GCBCNT(_gcbcnt),				\
		.bit = (_bit),					\
	}
#define DIV_ID_TO_BINDING_ID(id)	(E_SCU_CLK_MAX + id)
#define MUX_ID_TO_BINDING_ID(id)	(E_SCU_CLK_MAX	\
					 + E_SCU_CLKDIV_MAX	\
					 + id)

struct clk_hw *lin_clk_register_div_data(struct device *dev,
			const struct lin_clk_div_data *data,
					     void __iomem *base);
struct clk_hw *lin_clk_register_mux_data(struct device *dev,
			const struct lin_clk_mux_data *data,
					     void __iomem *base);
struct clk_hw *lin_clk_register_gate_data(struct device *dev,
			const struct lin_clk_gate_data *data,
					     void __iomem *base);
void lin_clk_div_init_locks(void);
void lin_clk_gate_init_locks(void);
void lin_clk_mux_init_locks(void);

#ifdef CONFIG_CLOCK_FPGA_ENV
extern u32 g_fpga_env_divider[NUMBER_OF_XCRG_INSTANCE][NUMBER_OF_XCRG_DIVIDER];
#endif


#endif
