/* Copyright 2022 Sony Corporation, SOCIONEXT INC. */
//#define TESTCODE_DMA_DRV	1

#ifdef TESTCODE_DMA_DRV
//#define TESTCODE_DMA_DRV_TRANS_PERF	1
//#define TESTCODE_DMA_DRV_LOCK_PERF	1
#endif

#ifndef _AXI_DW_AXI_DMAC_LLD_H
#define _AXI_DW_AXI_DMAC_LLD_H

#define D_SLP_US_BETWEEN_READS_10	(10)
#define D_TIMEOUT_US_100	(100)

#define D_CH_INT_STATUS_CLR	(0x0000000000000000ULL)

/* functions for LLD */
LLD_DMAC_CH_CONF *lld_dmac_ch_mng_get_config(const LLD_CH ch);
LLD_FUNC_FLAG lld_dmac_ch_mng_get_flag(const LLD_CH ch);
void lld_dmac_ch_mng_set_interrupt(const LLD_CH ch);
void lld_dmac_ch_mng_set_fact(const LLD_CH ch, LLD_FACT fact);
LLD_FUNC lld_dmac_ch_mng_get_int_func(const LLD_CH ch);
void *lld_dmac_ch_mng_get_cookies(const LLD_CH ch);
void lld_dmac_th_int_func(LLD_CH ch);
void lld_dmac_init(LLD_CH ch);
void lld_dmac_set_priority(LLD_CH ch, u32 priority);
void lld_dmac_ch_mng_set_int_status(const LLD_CH ch, uint64_t int_status);
raw_spinlock_t *lld_dmac_ch_mng_get_lock(const LLD_CH ch);

#ifdef TESTCODE_DMA_DRV
void lld_dmac_reg_write(const uint32_t reg_addr_offset, const LLD_CH ch, uint64_t value);
uint64_t lld_dmac_reg_read(const uint32_t reg_addr_offset, const LLD_CH ch);
uint64_t lld_dmac_cmn_reg_read(const uint32_t reg_addr_offset, const LLD_CH ch);
LLD_ER lld_dmac_get_auto_width(const LLD_CH ch, const LLD_DMAC_TRAN_INFO *tran_info,
																				uint32_t *src_width,  uint32_t *dst_width);
#endif /* TESTCODE_DMA_DRV */

#ifdef TESTCODE_DMA_DRV_TRANS_PERF
void lld_dmac_debug_info_set_nsec_start(struct timespec64 ts);
void lld_dmac_debug_info_set_nsec_end(struct timespec64 ts);
uint64_t lld_dmac_debug_info_get_nsec_diff(void);

#define TESTCODE_DMAC_DRV_TRANS_VARS \
	struct timespec64 ts

#define TESTCODE_DMAC_DRV_TRANS_GET_TIME \
	ktime_get_real_ts64(&ts)

#define TESTCODE_DMAC_DRV_TRANS_SET_NSEC_START \
	lld_dmac_debug_info_set_nsec_start(ts)

#define TESTCODE_DMAC_DRV_TRANS_SET_NSEC_END \
	lld_dmac_debug_info_set_nsec_end(ts)

#else /* TESTCODE_DMA_DRV_TRANS_PERF */

#define TESTCODE_DMAC_DRV_TRANS_VARS	do {} while(0)
#define TESTCODE_DMAC_DRV_TRANS_GET_TIME	do {} while(0)
#define TESTCODE_DMAC_DRV_TRANS_SET_NSEC_START	do {} while(0)
#define TESTCODE_DMAC_DRV_TRANS_SET_NSEC_END	do {} while(0)

#endif /* TESTCODE_DMA_DRV_TRANS_PERF */

#ifdef TESTCODE_DMA_DRV_LOCK_PERF
void lld_dmac_debug_info_init_max_lock_time(void);
void lld_dmac_debug_info_compare_and_set_max_lock_time(struct timespec64 ts_start, struct timespec64 ts_end, const char *func_name_1, const char *func_name_2);
uint64_t lld_dmac_debug_info_get_max_lock_time(void);

#define TESTCODE_DMAC_DRV_LOCK_VARS \
	struct timespec64 ts_start, ts_end

#define TESTCODE_DMAC_DRV_LOCK_GET_START \
	ktime_get_real_ts64(&ts_start)

#define TESTCODE_DMAC_DRV_LOCK_GET_END_AND_SET_MAX(msg) \
	do { \
		ktime_get_real_ts64(&ts_end); \
		lld_dmac_debug_info_compare_and_set_max_lock_time(ts_start, ts_end, __func__, (msg)); \
	} while (0)

#else /* TESTCODE_DMA_DRV_LOCK_PERF */

#define TESTCODE_DMAC_DRV_LOCK_VARS	do {} while(0)
#define TESTCODE_DMAC_DRV_LOCK_GET_START	do {} while(0)
#define TESTCODE_DMAC_DRV_LOCK_GET_END_AND_SET_MAX(msg)	do {} while(0)

#endif /* TESTCODE_DMA_DRV_LOCK_PERF */

#endif /* _AXI_DW_AXI_DMAC_LLD_H */
