/*
 *  driver/misc/cxd/dma/dw_axi_dmac.h
 *
 *   dw-axi-dmac LLD driver I/F header
 *
 *  Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef __CXD_DMA_DW_AXI_DMAC_H
#define __CXD_DMA_DW_AXI_DMAC_H

#include <linux/udif/types.h>
#include <linux/dmac_lld.h>
#include <mach/dw_axi_dmac.h>

#define N_DMA_CH		(LLD_CH_MAX + 1)

#define DW_DMAC_LL_SHIFT	6 /* Linked List: 2^6 bytes align */
#define DW_DMAC_LL_ALIGN	(1UL << DW_DMAC_LL_SHIFT)

struct hw_cxdma_info {
	LLD_DMAC_CH_INFO flow;   /* prev value */
	LLD_DMAC_TRAN_INFO mtran; /* for mem-to-mem single transfer */
	LLD_DMAC_TRAN_INFO ptran; /* for peri single transfer */
	/* internal use Linked List memory */
	UDIF_VP *mem;           /* kmalloc'd pointer */
	LLD_DMAC_LINKLIST *ll;  /* aligned to Linked List */
};
#define N_LLI 2

#endif /* __CXD_DMA_DW_AXI_DMAC_H */
