/*
 * driver/misc/cxd/dma/internel.h
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
 */
#ifndef __CXD_DMA_INTERNAL_H
#define __CXD_DMA_INTERNAL_H

#include "config.h"
#include "dw_axi_dmac.h"

#include <linux/udif/spinlock.h>
#include <linux/udif/list.h>

/*---------- override struct dma_request_async ----------*/
struct __dma_private_t {
	UDIF_LIST list;
	uint32_t pid;
};

#include <linux/dmac.h>

static_assert(sizeof(struct __dma_private_t) == sizeof(struct dma_private_t));
/*-------------------------------------------------------*/

typedef struct dma_request_async req_t;

struct dma_stat {
	int pending_cnt;
	unsigned long done_cnt, abort_cnt, err_cnt;
};

struct dma_chan_ctrl {
	uint ch;
	/* driver */
	UDIF_RAW_SPINLOCK lock;
	uint32_t flag;
	UDIF_LIST pending_list;
	req_t *cur;
	struct dma_stat stat;
	/*--- hw driver private ---*/
	struct hw_cxdma_info hw;
};
typedef struct dma_chan_ctrl chan_t;

#define LOCK(x)   udif_spin_lock_irqsave(&(x)->lock, flags)
#define UNLOCK(x) udif_spin_unlock_irqrestore(&(x)->lock, flags)

/* flag definition */
#define CHAN_FLAG_EN		0x00000001U
#define CHAN_FLAG_SUSPEND	0x00000002U

static inline bool dma_enabled(chan_t *chan)
{
	return !!(chan->flag & CHAN_FLAG_EN);
}

static inline void dma_flag_set_enable(chan_t *chan)
{
	chan->flag |= CHAN_FLAG_EN;
}

static inline void dma_flag_clr_enable(chan_t *chan)
{
	chan->flag &= ~CHAN_FLAG_EN;
}

static inline bool dma_suspended(chan_t *chan)
{
	return !!(chan->flag & CHAN_FLAG_SUSPEND);
}

static inline void dma_flag_set_suspend(chan_t *chan)
{
	chan->flag |= CHAN_FLAG_SUSPEND;
}

static inline void dma_flag_clr_suspend(chan_t *chan)
{
	chan->flag &= ~CHAN_FLAG_SUSPEND;
}

static inline bool dma_busy(chan_t *chan)
{
	return !!chan->cur;
}

extern chan_t *cxdma_get_chan(uint32_t ch);

/* dev I/F */
struct hw_cxdma_conf {
	uint priority;
	uint src_outstanding, dst_outstanding;
	uint qos;
};
extern int  hw_cxdma_check_args(req_t *req);
extern void hw_cxdma_config(chan_t *chan, struct hw_cxdma_conf *);
extern int  hw_cxdma_open(chan_t *chan);
extern void hw_cxdma_close(chan_t *chan);
extern int  hw_cxdma_start(chan_t *chan);
extern void hw_cxdma_stop(chan_t *chan);
extern void hw_cxdma_errstat(chan_t *chan, uint64_t *stat);
extern void hw_cxdma_dump(chan_t *chan);
extern void cxdma_cb(chan_t *chan, int err);

/* cdev I/F */
extern void cxdma_cdev_init(void);
extern void cxdma_cdev_exit(void);

/* proc I/F */
extern void cxdma_proc_init(void);
extern void cxdma_proc_exit(void);

/* log I/F */
extern void __cxdma_log(uint flag, uint ch, const char *fmt, ...);
  /* flag */
#define LOG_PR		0x01 /* use printk */
#define LOG_BT		0x02 /* use snsc_boot_time */
#define LOG_NO_CH	0x10 /* suppress channel number */
#define LOG_ERR		0x80 /* ERR */

#define cxdma_perr(fmt, ...)						\
	__cxdma_log(LOG_ERR|LOG_PR|LOG_BT|LOG_NO_CH, 0, fmt, ##__VA_ARGS__)
#define chan_perr(ch, fmt, ...)						\
	__cxdma_log(LOG_ERR|LOG_PR|LOG_BT, ch, fmt, ##__VA_ARGS__)
#define chan_errlog(ch, fmt, ...)				\
	__cxdma_log(LOG_ERR|LOG_BT, ch, fmt, ##__VA_ARGS__)
#define chan_log(ch, fmt, ...)				\
	__cxdma_log(LOG_BT, ch, fmt, ##__VA_ARGS__)

#endif /* __CXD_DMA_INTERNAL_H */
