/*
 * drivers/gpioint/gpioint.c
 *
 * Copyright 2023 Sony Corporation
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/udif/module.h>

static UDIF_ERR gpioint_probe(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	if (!dev || ch >= UDIF_NR_GPIOINT){
		return UDIF_ERR_PAR;
	}
	udif_devio_hclk(dev, ch, 1);
	udif_devio_hrst(dev, ch, 0);
	return UDIF_ERR_OK;
}

static UDIF_ERR gpioint_remove(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	if (!dev || ch >= UDIF_NR_GPIOINT){
		return UDIF_ERR_PAR;
	}
	udif_devio_hrst(dev, ch, 1);
	udif_devio_hclk(dev, ch, 0);
	return UDIF_ERR_OK;
}

static UDIF_ERR gpioint_suspend(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	if (!dev || ch >= UDIF_NR_GPIOINT){
		return UDIF_ERR_PAR;
	}
	return UDIF_ERR_OK;
}

static UDIF_ERR gpioint_resume(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	if (!dev || ch >= UDIF_NR_GPIOINT){
		return UDIF_ERR_PAR;
	}
	udif_devio_hclk(dev, ch, 1);
	udif_devio_hrst(dev, ch, 0);
	return UDIF_ERR_OK;
}

static UDIF_DRIVER_OPS gpioint_ops = {
	.probe		= gpioint_probe,
	.remove		= gpioint_remove,
	.suspend	= gpioint_suspend,
	.resume		= gpioint_resume,
};

UDIF_IDS(gpioint_devs) = {
	UDIF_ID(UDIF_ID_GPIOINT, UDIF_CH_MASK_DEFAULT),
};
UDIF_DEPS(gpioint_deps) = {};

UDIF_DECLARE_DRIVER(udif_gpioint, "gpioint", "1.0", &gpioint_ops, gpioint_devs, gpioint_deps, NULL);

static int __init __udif_init_gpioint(void)
{
	UDIF_DRIVER *drv = &udif_gpioint;

	return udif_driver_register(&drv, 1);
}
arch_initcall(__udif_init_gpioint);
