/*
 * drivers/misc/cxd/pcie/host.c
 *
 *
 * Copyright 2023 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include "internal.h"

void pcie_dwc_notify(struct device *dev, int ch, enum PCIE_NOTIFY event, void __iomem *link_base)
{
	if (!dev)
		return;
	if (ch < 0 || N_PCIE <= ch)
		return;
	if (event >= PCIE_NOTIFY_MAX)
		return;
	switch (event) {
	case PCIE_NOTIFY_START:
		pcie_cxd_state_init(ch);
		pcie_aximon_start(ch, link_base);
		pcie_ltssm_start(ch, link_base);
		break;
	case PCIE_NOTIFY_TERM:
		pcie_aximon_stop(ch, link_base);
		pcie_ltssm_stop(ch, link_base);
		break;
	case PCIE_NOTIFY_IRQCOM:
		pcie_aximon_intr(ch, link_base);
		break;
	default:
		return;
	}
}
