/*
 * drivers/misc/cxd/pcie/internal.h
 *
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/pci.h>
#include "../../../pci/pci.h"
#include <linux/pcie_dwc.h>
#include <mach/pcie_export.h>

#define N_PCIE	PCIE_CH_MAX

#define DEFAULT_CH	PCIE_CH3

#define PORT_UNDEF	(~0U)

struct pcie_link {
	const char *name;
	int (*read)(struct pci_dev *);
	int (*change)(struct pci_dev *, int, unsigned int, unsigned int);
	const int *delay_us;
	const int *sleep_us;
	const int *timeout_us;
};

extern void pcie_log(const char *fmt, ...);
extern char *cxpcie_get_name(int ch);
extern void cxpcie_proc_init(void);
extern void cxpcie_proc_create(int ch);
/* aspm lock */
extern int pcie_aspm_ctrl_trylock(int ch);
extern int pcie_aspm_ctrl_lock(int ch);
extern int pcie_aspm_ctrl_unlock(int ch);
/* link width and speed */
extern int cxpcie_get_link(int ch, const struct pcie_link *link);
extern int cxpcie_set_link(int ch, unsigned int target_link, const struct pcie_link *link);
extern int cxpcie_check_dev_state(int ch);
/* perst gpio */
extern void pcie_set_perst(int ch, int assert);
extern int pcie_has_perst(int ch);
extern int __pcie_get_perst(int ch);
extern int pcie_get_perst(int ch);
/* AXIMON */
void pcie_aximon_start(int ch, void __iomem *base);
void pcie_aximon_stop(int ch, void __iomem *base);
void pcie_aximon_intr(int ch, void __iomem *base);
int pcie_aximon_stat(int ch, void __iomem *base);
/* prsnt */
void pcie_cxd_state_init(int ch);
int pcie_cxd_status(int ch);
/* LTSSM */
extern void pcie_ltssm_start(int ch, void __iomem *base);
extern void pcie_ltssm_stop(int ch, void __iomem *base);
extern struct proc_ops cxpcie_proc_ltssm_fops;
