/*
 * drivers/misc/cxd/pcie/module.c
 *
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/kernel.h>
#include <linux/pci.h>
#include <linux/module.h>
#include <linux/udif/module.h>
#include <linux/udif/delay.h>
#include <linux/udif/timer.h>

#include "internal.h"

#define DRV_NAME "pcie"
#define DRV_VER  "1.0"

static UDIF_ERR cxpcie_probe(const UDIF_DEVICE *dev, UDIF_CH ch, UDIF_VP data)
{
	int i;

	for (i = 0; i < N_PCIE; i++) {
		cxpcie_proc_create(i);
		pcie_dwc_root_ctrl(i, PCIE_CTRL_PREP_OFF);
	}
	return UDIF_ERR_OK;
}

static UDIF_INIT UDIF_ERR cxpcie_init(UDIF_VP data)
{
	cxpcie_proc_init();
	return UDIF_ERR_OK;
}

static UDIF_DRIVER_OPS cxpcie_ops = {
	.init		= cxpcie_init,
	.probe		= cxpcie_probe,
};

UDIF_IDS(cxpcie_ids) = {};
UDIF_DEPS(cxpcie_deps) = {};
UDIF_MODULE(cxpcie, DRV_NAME, DRV_VER, cxpcie_ops, cxpcie_ids, cxpcie_deps, NULL);
