/*
 * drivers/misc/cxd/pcie/root_ctrl.c
 *
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/mutex.h>

#include "internal.h"

static DEFINE_MUTEX(pcie_ctrl_mutex);

void pcie_root_ctrl(int ch, int enable)
{
	int ret = 0;

	pcie_log("B PCI%d pcie_root_ctrl %d", ch, enable);
	mutex_lock(&pcie_ctrl_mutex);

	if (ch < 0 || N_PCIE <= ch) {
		printk(KERN_ERR "ERROR:%s:ch=%d\n", __func__, ch);
		ret = -EINVAL;
		goto end;
	}
	ret = pcie_dwc_root_ctrl(ch, enable);
	if (ret) {
		printk(KERN_ERR "ERROR:%s:ch=%d,enable=%d:ret=%d\n",
		       __func__, ch, enable, ret);
		goto end;
	}
	if (!enable) {
		pcie_set_perst(ch, 1); /* assert /PERST */
	}

end:
	pcie_log("E PCI%d pcie_root_ctrl %d", ch, ret);
	mutex_unlock(&pcie_ctrl_mutex);
	return;
}
EXPORT_SYMBOL(pcie_root_ctrl);

/* for backward compat */
int pcie_slot_ctrl(int id, int enable)
{
	pcie_log("B PCI%d pcie_slot_ctrl %d", id, enable);
	pcie_log("E PCI%d pcie_slot_ctrl %d", id, enable);
	return 0;
}
EXPORT_SYMBOL(pcie_slot_ctrl);

/* for backward compat */
int pcie_wait_datalink(int ch, unsigned int msec)
{
	pcie_log("B %s %d", __func__, ch);
	pcie_log("E %s %d", __func__, ch);
	return 0;
}
EXPORT_SYMBOL(pcie_wait_datalink);

int pcie_hot_add(int ch)
{
	pcie_log("B %s %d", __func__, ch);
	pcie_root_ctrl(ch, 1);
	pcie_log("E %s %d", __func__, ch);
	return 0;
}
EXPORT_SYMBOL(pcie_hot_add);

int pcie_hot_remove(int ch)
{
	pcie_log("B %s %d", __func__, ch);
	pcie_root_ctrl(ch, 0);
	pcie_log("E %s %d", __func__, ch);
	return 0;
}
EXPORT_SYMBOL(pcie_hot_remove);
