/*
 * driver/misc/cxd/pciedma/dwc_pcie.c
 *
 *   DWC PCIe Controller driver I/F
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include "internal.h"
#include "dwc_pcie.h"

int hw_pcidma_check_args(req_t *req) { return 0; }

static void hw_pcidma_cb(uint64_t err, void *cookies)
{
	int result;

	result = (err) ? -1 : 0;
	pcidma_cb((chan_t *)cookies, result);
}

int hw_pcidma_start(chan_t *chan)
{
	req_t *req = chan->cur;
	int ret;

	ret = pcie_dwc_dma_start((struct pcidma_param *)req, hw_pcidma_cb,
				 (void *)chan);
	if (ret) {
		chan_perr(chan->pcie_id, chan->dmac_ch, "pcie_dwc_dma_start:ret=%d", ret);
		return -1;
	}
	chan->stat.go_cnt++;
	return 0;
}

void hw_pcidma_stop(chan_t *chan)
{
	int ret;

	ret = pcie_dwc_dma_stop(chan->pcie_id, chan->dmac_ch);
	if (ret) {
		chan_perr(chan->pcie_id, chan->dmac_ch, "pcie_dwc_dma_stop:ret=%d", ret);
	}
}

int hw_pcidma_open(chan_t *chan) { return 0; }
void hw_pcidma_close(chan_t *chan) {}
