/*
 * driver/misc/cxd/pciedma/log.c
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */

#include <linux/snsc_boot_time.h>
#include "internal.h"

void __pcidma_log(uint flag, uint pci, uint ch, const char *fmt, ...)
{
	char buf[64], *p;
	int len, rest;
	va_list args;

	p = buf;
	rest = sizeof buf;

	len = scnprintf(p, rest, "%sPCIDMA:", (flag & LOG_ERR)?"ERR:":"");
	p += len;
	rest -= len;
	if (!(flag & LOG_NO_ID)) {
		if (flag & LOG_NO_CH) {
			len = scnprintf(p, rest, "%u:", pci);
			p += len;
			rest -= len;
		} else {
			len = scnprintf(p, rest, "%u:%u:", pci, ch);
			p += len;
			rest -= len;
		}
	}
	va_start(args, fmt);
	vscnprintf(p, rest, fmt, args);
	va_end(args);

	if (flag & LOG_BT)
		BOOT_TIME_ADD1(buf);
	if (flag & LOG_PR)
		printk(KERN_ERR "%s\n", buf);
}
