/*
 * drivers/soc/cxd/boot.S
 *
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm64/kernel/head.S.
 */
/*
 * Low-level CPU initialisation
 * Based on arch/arm/kernel/head.S
 *
 * Copyright (C) 1994-2002 Russell King
 * Copyright (C) 2003-2012 ARM Ltd.
 * Authors:	Catalin Marinas <catalin.marinas@arm.com>
 *		Will Deacon <will.deacon@arm.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/linkage.h>
#include <linux/init.h>
#include <asm/assembler.h>
#include <asm/cputype.h>
#include "include/head_init.h"
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
#include "include/bootram.h"
#endif

	.pushsection ".idmap.text", "ax"
#if !defined(CONFIG_EJ_SIMPLE_LOADER)
SYM_FUNC_START(cxd90xxx_init)
	cmp	x24, CurrentEL_EL3
	b.ne	1f
	/* turn MMU off and disable D-Cache */
	mrs	x10, sctlr_el1
	bic	x10, x10, #SCTLR_ELx_M
	bic	x10, x10, #SCTLR_ELx_C
	msr	sctlr_el1, x10
	mrs	x10, sctlr_el3
	bic	x10, x10, #SCTLR_ELx_M
	bic	x10, x10, #SCTLR_ELx_C
	msr	sctlr_el3, x10
	isb
	tlbi	alle3
	dsb	nsh
1:
	ret
SYM_FUNC_END(cxd90xxx_init)

SYM_FUNC_START(cxd90xxx_smp_init)
	/* x0: pa(ej_secondary_entry) */
	cmp	x24, CurrentEL_EL3
	b.ne	1f
	/* boot secondary CPUs */
	ldr	x5, =CXD90XXX_BOOTRAM_WORK
	str	w0, [x5, #CXD90XXX_BOOTRAM_VEC+0x04] /* CPU#1 */
	str	w0, [x5, #CXD90XXX_BOOTRAM_VEC+0x08] /* CPU#2 */
	str	w0, [x5, #CXD90XXX_BOOTRAM_VEC+0x0c] /* CPU#3 */
	strb	wzr, [x5, #CXD90XXX_BOOTRAM_FLAG+1]  /* CPU#1 */
	strb	wzr, [x5, #CXD90XXX_BOOTRAM_FLAG+2]  /* CPU#2 */
	strb	wzr, [x5, #CXD90XXX_BOOTRAM_FLAG+3]  /* CPU#3 */
	dsb	sy
	sev
1:
	ret
SYM_FUNC_END(cxd90xxx_smp_init)

SYM_FUNC_START(cxd90xxx_secondary_init)
	cmp	x24, CurrentEL_EL3
	b.ne	1f
	/* clear boot flag */
	ldr	x5, =CXD90XXX_BOOTRAM_WORK+CXD90XXX_BOOTRAM_FLAG
	mrs	x0, mpidr_el1
	ands	x0, x0, #MPIDR_LEVEL_MASK	// CPU#
	mov	w1, #0xff
	strb	w1, [x5, x0]
	/* address conversion */
	orr	lr, lr, #0x200000000 // bit[35..32]
1:
	ret
SYM_FUNC_END(cxd90xxx_secondary_init)
#endif /* !CONFIG_EJ_SIMPLE_LOADER */

SYM_FUNC_START(v8_boot)
	// This routine is called by CPU#0.
	// destroy: x27, x10
	mov	x27, lr
	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	bl	gic_dist_init
	bl	gic_cpu_init
	bl	el3_setup
1:
	smp_enable
	ret	x27
SYM_FUNC_END(v8_boot)

/*------------- EL3 --------------*/
#define SCR_RW		0x400
#define SCR_SMD		0x080
#define SCR_RES1	0x030
#define SCR_NS		0x001
#define SPSR_D_MASK	0x200
#define SPSR_A_MASK	0x100
#define SPSR_I_MASK	0x080
#define SPSR_F_MASK	0x040
#define SPSR_ALL_MASK	(SPSR_D_MASK|SPSR_A_MASK|SPSR_I_MASK|SPSR_F_MASK)
#define SPSR_M_EL2H	0x009
#define SPSR_M_EL1H	0x005
#define ACTL_L2A	0x40
#define ACTL_L2E	0x20
#define ACTL_L2		0x10
#define ACTL_CPUE	0x02
#define ACTL_CPUA	0x01
#define ACTL_ALL_ACC	(ACTL_L2A|ACTL_L2E|ACTL_L2|ACTL_CPUE|ACTL_CPUA)

#define SPSR_VAL (SPSR_ALL_MASK|SPSR_M_EL1H)

/*------------- EL2 --------------*/
#define HCR_RW			0x80000000
#define CPTR_RES1		0x000033FF
#define CNTHCTL_EL1PCEN		0x00000002
#define CNTHCTL_EL1PCTEN	0x00000001

SYM_FUNC_START(el3_setup)
	msr	elr_el3, lr			// save LR
	// EL3 registers
	mov	x10, #(SCR_RW|SCR_RES1|SCR_NS)
	msr	scr_el3, x10
	isb
	msr	cptr_el3, xzr			// no trap
	mov	x10, #ACTL_ALL_ACC
	msr	actlr_el3, x10
#if !defined(CONFIG_ARCH_CXD90XXX_QEMU)
	ldr	x10, =GT_FRQ
	msr	cntfrq_el0, x10
#endif
	// EL2 registers
	msr	hstr_el2, xzr			// no trap
	mov	x10, #HCR_RW			// EL1 is AARCH64
	msr	hcr_el2, x10
	isb
	mov	x10, #CPTR_RES1			// no trap
	msr	cptr_el2, x10
	mov	x10, #ACTL_ALL_ACC
	msr	actlr_el2, x10
	isb
	mov	x10, #(CNTHCTL_EL1PCEN|CNTHCTL_EL1PCTEN)
	msr	cnthctl_el2, x10
	msr	cntvoff_el2, xzr
	// Populate ID registers */
	mrs	x10, midr_el1
	msr	vpidr_el2, x10
	mrs	x10, mpidr_el1
	msr	vmpidr_el2, x10
	// EL transision
	ldr	x10, =SPSR_VAL
	msr	spsr_el3, x10
	eret
SYM_FUNC_END(el3_setup)

	/*----------- GIC CPU I/F -------------*/
#define GICC_CTLR_EOIMODENS	0x400
#define GICC_CTLR_EOIMODES	0x200
#define GICC_CTLR_EOI		(GICC_CTLR_EOIMODENS|GICC_CTLR_EOIMODES)
#define GICC_CTLR_IRQNOBYPGRP1	0x100
#define GICC_CTLR_FIQNOBYPGRP1	0x080
#define GICC_CTLR_IRQNOBYPGRP0	0x040
#define GICC_CTLR_FIQNOBYPGRP0	0x020
#define GICC_CTLR_NOBYPASS	(GICC_CTLR_IRQNOBYPGRP1|GICC_CTLR_FIQNOBYPGRP1|GICC_CTLR_IRQNOBYPGRP0|GICC_CTLR_FIQNOBYPGRP0)
#define GICC_CTLR_CBPR		0x010
#define GICC_CTLR_FIQEN		0x008
#define GICC_CTLR_ACKCTL	0x004 /* GICv2 only */
#define GICC_CTLR_ENGRP1	0x002
#define GICC_CTLR_ENGRP0	0x001
#define GICC_PMR_NSMASK		0x80

#ifdef CXD90XXX_GICV2
	/*----------- GIC v2 -------------*/
#include <linux/irqchip/arm-gic.h>
#define GICD_CTLR_ENGRP1	0x2
#define GICD_CTLR_ENGRP0	0x1
#define GICD_IGRP_GROUP1	0xffffffff
gic_dist_init:
	ldr	x10, =GICD_BASE
	mov	w11, #GICD_CTLR_ENGRP1
	str	w11, [x10, #GIC_DIST_CTRL]
	// initialize GICD_IGROUPRn
	add	x10, x10, #GIC_DIST_IGROUP+4	// IGROUP#1..IGROUP#N
	mov	w11, #GICD_IGRP_GROUP1
	mov	w12, #(GICD_NSPI/32)
1:
	str	w11, [x10], #4
	subs	w12, w12, #1
	b.ne	1b
	ret

SYM_FUNC_START(gic_cpu_init)
	ldr	x10, =GICD_BASE
	mov	w11, #GICD_IGRP_GROUP1
	str	w11, [x10, #GIC_DIST_IGROUP]	// IGROUP#0
	ldr	x10, =GICC_BASE
	mov	w11, #(GICC_CTLR_EOI|GICC_CTLR_NOBYPASS|GICC_CTLR_ENGRP1)
	str	w11, [x10, #GIC_CPU_CTRL]
	mov	w11, #GICC_PMR_NSMASK
	str	w11, [x10, #GIC_CPU_PRIMASK]
	ret
SYM_FUNC_END(gic_cpu_init)

#else /* CXD90XXX_GICV2 */
	/*----------- GIC v3 -------------*/
#include <linux/irqchip/arm-gic-v3.h>
#define GICD_ENGRP1NS	0x02
#define GICD_ENGRP1S	0x04
#define GICD_ARE_S	0x10
#define GICD_ARE_NS	0x20
#define GICD_CTRL_VAL	(GICD_ARE_S|GICD_ARE_NS)
#define G1NS_IGRP	0xffffffff
#define GICR_SHIFT	17 /* RD + SGI == 128KB */
#define GICR_SGI_OFFS	0x00010000
#define GICC_CTLR	0x00
#define GICC_PMR	0x04
#define ICC_SRE_EL3	S3_6_C12_C12_5
#define ICC_SRE_EL2	S3_4_C12_C9_5
#define ICC_SRE_EL1	S3_0_C12_C12_5
gic_dist_init:
	ldr	x10, =GICD_BASE
	mov	w11, #GICD_CTRL_VAL
	str	w11, [x10, #GICD_CTLR]

	// set SPI to G1NS
	mov	w11, #G1NS_IGRP
	mov	w12, #(GICD_NSPI/32)
1:
	str	w11, [x10, #GICD_IGROUPR+4]	// IGROUP#1..IGROUP#N
	str	wzr, [x10, #GICD_IGRPMODR+4]	// IGRPMODR#1..IGRPMODR#N
	add	x10, x10, #4
	subs	w12, w12, #1
	b.ne	1b
	ret

SYM_FUNC_START(gic_cpu_init)
	ldr	x10, =GICR_BASE
	mrs	x11, mpidr_el1
	and	x11, x11, #MPIDR_LEVEL_MASK	// CPU#
	lsl	x11, x11, #GICR_SHIFT
	add	x10, x10, x11			// RD_base

	// Enable CPU I/F
	str	wzr, [x10, #GICR_WAKER]
1:
	ldr	w11, [x10, #GICR_WAKER]
	ands	w11, w11, #GICR_WAKER_ChildrenAsleep
	b.ne	1b

	// set SGI/PPI to G1NS
	add	x10, x10, #GICR_SGI_OFFS	// SGI_base
	mov	w11, #G1NS_IGRP
	str	w11, [x10, #GICR_IGROUPR0]	// IGROUP#0
	str	wzr, [x10, #GICR_IGRPMODR0]	// IGRPMODR#0

	// enable SRE
	mov	x10, #(SCR_RW|SCR_RES1|SCR_NS)
	msr	scr_el3, x10
	isb
	mov	x10, #(ICC_SRE_EL2_ENABLE|ICC_SRE_EL2_SRE)
	msr	ICC_SRE_EL3, x10
	isb
	msr	ICC_SRE_EL2, x10
	isb
 	ret
SYM_FUNC_END(gic_cpu_init)
#endif /* CXD90XXX_GICV2 */

#if 0
gic_dump:
	mov	w0, #'\r'
	bl	printch
	mov	w0, #'\n'
	bl	printch
	ldr	x11, =GICD_BASE
	mov	w12, #1024
2:
	ldr	w0, [x11]
	bl	printhex32
	mov	w0, #' '
	bl	printch
	add	x11, x11, #4
	sub	w12, w12, #1
	ands	w0, w12, #0x7
	b.ne	1f
	mov	w0, #'\r'
	bl	printch
	mov	w0, #'\n'
	bl	printch
1:
	cbnz	w12, 2b
1:
	wfi
	b	1b
#endif
 	.ltorg
	.popsection
