/*
 * drivers/soc/cxd/debug.S
 *
 * Debug print functions
 *
 * Copyright 2018 Sony Corporation
 *
 * This code is based on arch/arm/kernel/debug.S
 */
/*
 *  linux/arch/arm/kernel/debug.S
 *
 *  Copyright (C) 1994-1999 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  32-bit debugging code
 */
#include <linux/linkage.h>
#include <asm/assembler.h>

		.text
		.pushsection ".idmap.text", "ax"
/*
 * Some debugging routines (useful if you've got MM problems and
 * printk isn't working).  For DEBUGGING ONLY!!!  Do not leave
 * references to these in a production kernel!
 */

#include "include/debug-macro.S"

		.macro	addruart_current, rx, tmp1, tmp2
		addruart	\tmp1, \tmp2
		mrs	\rx, sctlr_el1
		tst	\rx, #1
		bne	1001f
		mov	\rx, \tmp1
		b	1002f
1001:
		mov	\rx, \tmp2
1002:
		.endm

/*
 * Useful debugging routines
 */
SYM_FUNC_START(printhex64)
		mov	x1, #16
		b	printhex
SYM_FUNC_END(printhex64)

SYM_FUNC_START(printhex32)
		mov	x1, #8
		b	printhex
SYM_FUNC_END(printhex32)

SYM_FUNC_START(printhex8)
		mov	x1, #8
		b	printhex
SYM_FUNC_END(printhex8)

SYM_FUNC_START(printhex4)
		mov	x1, #4
		b	printhex
SYM_FUNC_END(printhex4)

SYM_FUNC_START(printhex2)
		mov	x1, #2
printhex:	adr	x2, hexbuf
		add	x3, x2, x1
		strb	wzr, [x3]
1:		and	x1, x0, #15
		mov	x0, x0, lsr #4
		cmp	x1, #10
		bge	2f
		add	x1, x1, #'0'
		b	3f
2:
		add	x1, x1, #'a' - 10
3:
		strb	w1, [x3, #-1]!
		cmp	x3, x2
		b.ne	1b
		mov	x0, x2
		b	printascii
SYM_FUNC_END(printhex2)

hexbuf:		.space 32

		.ltorg

SYM_FUNC_START(printascii)
		addruart_current x3, x1, x2
		b	2f
1:		waituart w2, x3
		senduart w1, x3
		busyuart w2, x3
		cmp	w1, #'\n'
		b.eq	3f
2:
		ldrb	w1, [x0], #1
		cbnz	w1, 1b
		ret
3:
		mov	w1, #'\r'
		b	1b
SYM_FUNC_END(printascii)

SYM_FUNC_START(printch)
		addruart_current x3, x1, x2
		waituart w2, x3
		senduart w0, x3
		busyuart w2, x3
		ret
SYM_FUNC_END(printch)

#ifdef CONFIG_DEBUG_EARLY
SYM_FUNC_START(_printch)
		// w8: ch
		// x5,x6,x7: corrupted
		addruart_current x5, x6, x7
		waituart w6, x5
		senduart w8, x5
		busyuart w6, x5
		ret
SYM_FUNC_END(_printch)
#endif /* CONFIG_DEBUG_EARLY */

SYM_FUNC_START(uart_init)
	uart_portconfig
	uart_setup
	ret
SYM_FUNC_END(uart_init)
		.ltorg
		.popsection
