/*
 * drivers/soc/cxd/export/mach/dw_axi_dmac.h
 *
 * Copyright 2022 Sony Corporation
 *
 */
#ifndef __MACH_DW_AXI_DMAC_H
#define __MACH_DW_AXI_DMAC_H

/* AXI bus width: 128bit(16byte) */
#define MACH_LLD_DMAC_WIDTH	LLD_DMAC_WIDTH128
#define MACH_DW_DMAC_WIDTH_SHIFT 4 /* 2^4 bytes */
#define MACH_DW_DMAC_WIDTH	(1UL << MACH_DW_DMAC_WIDTH_SHIFT)

/* AXI bus burst size: 512byte(32 burst) */
#define MACH_LLD_DMAC_BSIZE	LLD_DMAC_BSIZE32

/* number of master I/F: 1 */
#define MACH_DW_DMAC_LLI_MASTER LLD_DMAC_AXI_MASTER1
#define MACH_DW_DMAC_SRC_MASTER LLD_DMAC_AXI_MASTER1
#define MACH_DW_DMAC_DST_MASTER LLD_DMAC_AXI_MASTER1

/* AXI outstanding limit: 16 */
#define MACH_DW_DMAC_OST	15

#endif /* __MACH_DW_AXI_DMAC_H */
