/*
 * drivers/udif/mach-cxd90xxx/include/mach/gic_export.h
 *
 * MPCore Distributed Interrupt Controller definitions
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on include/asm-arm/hardware/gic.h.
 */
/*
 *  linux/include/asm-arm/hardware/gic.h
 *
 *  Copyright (C) 2002 ARM Limited, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef __ARCH_CXD90XXX_GIC_EXPORT_H
#define __ARCH_CXD90XXX_GIC_EXPORT_H

#include <linux/compiler.h>
#include <linux/irqchip/arm-gic-v3.h>
#include <mach/platform.h>

#define GICD_ROUTER	0x6000
#define GICD_SPISR	0xc080

/* Enable, Pending, Active, LineLevel reg. */
#define GIC_IRQ_BITS_SHIFT	5 /* packed 2^5 in u32 */
#define GIC_IRQ_BITS_MASK	((1 << GIC_IRQ_BITS_SHIFT) - 1)
#define GIC_IRQ_BITMASK(irq)	(1 << ((irq) & GIC_IRQ_BITS_MASK))
#define GIC_IRQ_OFFSET(irq)	(((irq) >> GIC_IRQ_BITS_SHIFT) << 2)

#define GIC_IRQ_PENDING(irq)	(readl_relaxed(VA_GIC_DIST + GICD_ISPENDR + GIC_IRQ_OFFSET(irq)) & GIC_IRQ_BITMASK(irq))

#define GIC_IRQ_RAWSTATUS(irq)	(readl_relaxed(VA_GIC_DIST + GICD_SPISR + GIC_IRQ_OFFSET(irq)) & GIC_IRQ_BITMASK(irq))

/* Priority reg. */
#define GIC_PRIO_BITS_WIDTH_SHIFT 3 /* width is 2^3 bits */
#define GIC_PRIO_BITS_SHIFT	(5 - GIC_PRIO_BITS_WIDTH_SHIFT) /* packed 2^2 in u32 */
#define GIC_PRIO_BITS_MASK	((1 << GIC_PRIO_BITS_SHIFT) - 1)
#define GIC_PRIO_OFFSET(irq)    (((irq) >> GIC_PRIO_BITS_SHIFT) << 2)
#define GIC_PRIO_DATA_SHIFT(irq) (((irq) & GIC_PRIO_BITS_MASK) << GIC_PRIO_BITS_WIDTH_SHIFT)

/* Configuration reg. */
#define GIC_CONFIG_BITS_WIDTH_SHIFT 1 /* width is 2^1 bits */
#define GIC_CONFIG_BITS_WIDTH	(1 << GIC_CONFIG_BITS_WIDTH_SHIFT)
#define GIC_CONFIG_BITS_SHIFT	(5 - GIC_CONFIG_BITS_WIDTH_SHIFT) /* packed 2^4 in u32 */
#define GIC_CONFIG_BITS_MASK	((1 << GIC_CONFIG_BITS_SHIFT) - 1)
#define GIC_CONFIG_OFFSET(irq)	(((irq) >> GIC_CONFIG_BITS_SHIFT) << 2)
#define GIC_CONFIG_DATA_SHIFT(irq) (((irq) & GIC_CONFIG_BITS_MASK) << GIC_CONFIG_BITS_WIDTH_SHIFT)
#define GIC_CONFIG_DATA_MASK	((1 << GIC_CONFIG_BITS_WIDTH) - 1)
#define GIC_CONFIG_EDGE	0x2

#define GIC_IRQ_ROUTER(irq)	(VA_GIC_DIST + GICD_ROUTER + ((irq)<<3))

#define gic_setirq(irq)		writel_relaxed(GIC_IRQ_BITMASK(irq), VA_GIC_DIST + GICD_ISPENDR + GIC_IRQ_OFFSET(irq))
#define gic_clearirq(irq)	writel_relaxed(GIC_IRQ_BITMASK(irq), VA_GIC_DIST + GICD_ICPENDR + GIC_IRQ_OFFSET(irq))
#define gic_pollirq(irq)	!!GIC_IRQ_RAWSTATUS(irq)
#define gic_maskirq(irq, enable) \
({ \
	if (enable) \
		writel_relaxed(GIC_IRQ_BITMASK(irq), VA_GIC_DIST + GICD_ISENABLER + GIC_IRQ_OFFSET(irq)); \
	else \
		writel_relaxed(GIC_IRQ_BITMASK(irq), VA_GIC_DIST + GICD_ICENABLER + GIC_IRQ_OFFSET(irq)); \
})

#endif /* __ARCH_CXD90XXX_GIC_EXPORT_H */
