/*
 * mach-cxd90xxx/include/mach/irqs.h
 *
 * IRQ definitions
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on include/asm-arm/arch-realview/irqs.h.
 */
/*
 *  linux/include/asm-arm/arch-realview/irqs.h
 *
 *  Copyright (C) 2003 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MACH_CXD90XXX_IRQS_H
#define __MACH_CXD90XXX_IRQS_H

/* SGI: 0-15
   PPI: 16-31
   SPI: 32-346 */
#define NR_GIC_SPI			(347 - 32)

#define IRQ_GIC_START			32

#define IRQ_DMAC_BASE			277
#define IRQ_DMAC(x)			(IRQ_DMAC_BASE + (x))

#define IRQ_GPIO_BASE			120
#define IRQ_GPIO(x)			(IRQ_GPIO_BASE + (x))
#define NR_GPIO_IRQ			28

#define IRQ_PMU				23 /* PPI */

#define IRQ_UART0			286
#define IRQ_UART1			283
#define IRQ_UART2			284
#define IRQ_UART3			285

#define IRQ_CPUINT_BASE			72
#define IRQ_CPUINT(x)			(IRQ_CPUINT_BASE + (x))
#define NR_CPUINT_IRQ			4

#define IRQ_WDOG_INT			76
#define IRQ_WDOG			77
#define IRQ_TIMER_BASE			104
#define IRQ_TIMER(x)			(IRQ_TIMER_BASE + (x))

#define IRQ_LDEC			269

#define IRQ_SIO_M			148
#define IRQ_SIO_C			149

#define IRQ_PCIE1			168
#define IRQ_PCIE2			180
#define IRQ_PCIE0			192
#define IRQ_PCIE3			212
#define IRQ_PCIE4			232

#define IRQ_MS0				268

#define IRQ_SDIF_BASE			243
#define IRQ_SDIF(x)			(IRQ_SDIF_BASE + (x)*9)
#define IRQ_EMMC0			298

#ifndef __ASSEMBLY__
extern void raise_irq(unsigned int cpu, unsigned int irq);
extern int gpiopin_to_irq(unsigned int port, unsigned int bit);
#endif /* !__ASSEMBLY__ */
#endif /* __MACH_CXD90XXX_IRQS_H */
