/*
 * drivers/soc/cxd/export/mach/pcie_export.h
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __SOC_CXD_EXPORT_MACH_PCIE_EXPORT_H
#define __SOC_CXD_EXPORT_MACH_PCIE_EXPORT_H

extern void pcie_root_ctrl(int ch, int enable);
extern int pcie_slot_ctrl(int id, int enable);
extern int pcie_wait_datalink(int busnr, unsigned int msec);
extern int pcie_hot_add(int busnr);
extern int pcie_hot_remove(int busnr);
extern int pcie_set_vboost(int ch, int vboost);
extern int pcie_get_link_width(int ch);
extern int pcie_set_link_width(int ch, unsigned int target_link_width);
extern int pcie_link_width_check_dev_state(int ch);
extern int pcie_link_width_check_dev_state_ch0(void);
typedef enum PCIE_LINK_SPEED {
	PCIE_LINK_SPEED_GEN1 = 1,
	PCIE_LINK_SPEED_GEN2 = 2,
	PCIE_LINK_SPEED_GEN3 = 3,
	PCIE_LINK_SPEED_GEN4 = 4,
} PCIE_LINK_SPEED;
extern int pcie_get_link_speed(int ch);
extern int pcie_set_link_speed(int ch, PCIE_LINK_SPEED target_link_speed);
extern int pcie_link_speed_check_dev_state(int ch);
extern int pcie_link_speed_check_dev_state_ch0(void);
extern const char *pcie_name(int ch);

#define N_PCIE	PCIE_CH_MAX

#define CXD_PCIE_CH	PCIE_CH3

#endif /* __SOC_CXD_EXPORT_MACH_PCIE_EXPORT_H */
