/*
 * mach-cxd90xxx/include/mach/platform.h
 *
 * CXD90XXX address map
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __MACH_CXD90XXX_PLATFORM_H
#define __MACH_CXD90XXX_PLATFORM_H

#include <asm/memory.h>

#define IO_ADDRESS(x)	(CXD90XXX_IO_VA|(x))
#ifdef __ASSEMBLY__
#define IO_ADDRESSP(x)	IO_ADDRESS(x)
#else
#define IO_ADDRESSP(x)	(volatile void __iomem __force *)IO_ADDRESS(x)
#endif

#if defined(CONFIG_ARCH_CXD90XXX_QEMU)
#define DDR0_BASE               UL(0x040000000)
#define DDR0_SIZE               UL(0x008000000) /* 128MB */
#define DDR1_BASE               UL(0x100000000) /* dummy */
#define DDR1_SIZE               UL(0x002000000) /* 32MB */
#elif defined(CONFIG_ARCH_CXD90XXX_FVP)
#define DDR0_BASE               UL(0x900000000)
#define DDR0_SIZE               UL(0x008000000) /* 128MB */
#define DDR1_BASE               UL(0x980000000)
#define DDR1_SIZE               UL(0x002000000) /* 32MB */
#else
#define DDR0_BASE		UL(0x200000000)
#define DDR0_SIZE		UL(0x1FE000000) /* 8GB-32MB */
#define DDR1_BASE		UL(0x600000000)
#define DDR1_SIZE		UL(0x1FE000000) /* 8GB-32MB */
#endif

/*---------------- I/O ----------------*/
#define CXD90XXX_IO_BASE	UL(0xf0000000)
#define CXD90XXX_IO_SIZE	0x0D010000
#define CXD90XXX_IO_VA		UL(0xffffffff00000000)

#define CXD90XXX_UART0		UL(0xfc592000)
#define CXD90XXX_UART1		UL(0xf1a30000)
#define CXD90XXX_UART2		UL(0xf1a31000)
#define CXD90XXX_UART3		UL(0xf1a32000)

#define CXD90XXX_TIMER_BASE(x)	(UL(0xf1A20000) + 0x1000*(x))
#define VA_TIMER(x)		IO_ADDRESSP(CXD90XXX_TIMER_BASE(x))
#define CXD90XXX_WDT		UL(0xf1a3a000)
#define VA_WDT			IO_ADDRESSP(CXD90XXX_WDT)

#define CXD90XXX_TIMESTAMP	UL(0xf4100000)

#if defined(CONFIG_ARCH_CXD90XXX_QEMU)
#define CXD90XXX_GIC_DIST	UL(0x08000000)
#elif defined(CONFIG_ARCH_CXD90XXX_FVP)
#define CXD90XXX_GIC_DIST	UL(0x2f000000)
#else
#define CXD90XXX_GIC_DIST	UL(0xf4400000)
#endif
#define VA_GIC_DIST		IO_ADDRESSP(CXD90XXX_GIC_DIST)

#define CXD90XXX_GPIO_C(ch)	(UL(0xfc58e000) + 0x100*(ch))
#define CXD90XXX_GPIO_M(ch)	(UL(0xf1A40000) + 0x100*(ch))
#define CXD90XXX_GPIO_OFFS	0x40
#define CXD_GPIO_PORT_C(ch) ((ch) + CXD90XXX_GPIO_OFFS)
#define CXD_GPIO_PORT_M(ch) (ch)
#ifndef __ASSEMBLY__
static inline unsigned long PA_GPIO(int ch)
{
	if (ch < CXD90XXX_GPIO_OFFS)
		return CXD90XXX_GPIO_M(ch);
	return CXD90XXX_GPIO_C(ch - CXD90XXX_GPIO_OFFS);
}
#define VA_GPIO(ch)		IO_ADDRESSP(PA_GPIO(ch))
#endif

#define CXD90XXX_DDRPHY(x)	(UL(0xf2000000) + 0x01000000*(x))
#define VA_DDRPHY(x)		IO_ADDRESSP(CXD90XXX_DDRPHY(x))

#define CXD90XXX_PCIEPHY0	UL(0xf0c00000)
#define CXD90XXX_PCIEREG0	UL(0xf0cc0000)
#define CXD90XXX_PCIEPHY1	UL(0xf0c40000)
#define CXD90XXX_PCIEREG1	UL(0xf0cc8000)
#define CXD90XXX_PCIEPHY2	UL(0xf0c80000)
#define CXD90XXX_PCIEREG2	UL(0xf0cd0000)
#define CXD90XXX_PCIEPHY3	UL(0xfcc00000)
#define CXD90XXX_PCIEREG3	UL(0xfcc40000)
#define CXD90XXX_PCIEPHY4	UL(0xfc400000)
#define CXD90XXX_PCIEREG4	UL(0xfc440000)

#define CXD90XXX_CLKRST		UL(0xfc5b0000)
#define CXD90XXX_PLL(ch)	(CXD90XXX_CLKRST + ((ch)<<12))
#define VA_PLL(ch)		IO_ADDRESSP(CXD90XXX_PLL(ch))

#define CXD90XXX_MISC		UL(0xfc5e0000)
#define CXD90XXX_OCTRL(ch,reg)	(CXD900XX_MISC + OCTRL_##reg + ((ch)<<8))
#define CXD90XXX_CLKEN(ch)	(CXD90XXX_MISC+0x1000 + ((ch)<<4))
#define CXD90XXX_RESET(ch)	(CXD90XXX_MISC+0x1400 + ((ch)<<4))
#define CXD90XXX_CLKSEL		(CXD90XXX_MISC+0x1810)
#define CXD90XXX_WDT_MISC	(CXD90XXX_MISC+0x2A00)

/*---------------- SRAM ----------------*/
#define CXD90XXX_CSRAM_BASE	UL(0x0fd000000)
#define CXD90XXX_CSRAM_SIZE	SZ_64K
#define CXD90XXX_ESRAM0_BASE	UL(0x3fe000000)
#define CXD90XXX_ESRAM0_SIZE	SZ_16M
#define CXD90XXX_ESRAM1_BASE	UL(0x7fe000000)
#define CXD90XXX_ESRAM1_SIZE	SZ_16M

#endif /* __MACH_CXD90XXX_PLATFORM_H */
