/*
 * mach-cxd90xxx/include/mach/regs-clk.h
 *
 * CXD90XXX CLK registers
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __REGS_CLK_H
#define __REGS_CLK_H

#include <mach/regs-scu.h>
#define CLK_DATA	SCU_DATA
#define CLK_SET		SCU_SET
#define CLK_CLR		SCU_CLR

/* channels */
#define CLKEN_UART_C		4
# define CLKEN_UART_C_PCLK		8
#define CLKEN_GPIO_C		4
# define CLKEN_GPIO_C_PCLK		24
#define CLKEN_GPIOINT_C		4
# define CLKEN_GPIOINT_C_PCLK		25
#define CLKEN_SIO_C		5
# define CLKEN_SIO_C_PCLK		0
# define CLKEN_SIO_C_DCLK		1
#define CLKEN_CPUINT_M		8
# define CLKEN_CPUINT_M_PCLK		4
#define CLKEN_LDEC		8
# define CLKEN_LDEC_ACLK		8
# define CLKEN_LDEC_PCLK		9
#define CLKEN_FECCNT		8
# define CLKEN_FECCNT_ACLK		12
# define CLKEN_FECCNT_PCLK		13
#define CLKEN_CMMC		8
# define CLKEN_CMMC_ACLK		24
# define CLKEN_CMMC_PCLK		26
#define CLKEN_GPIO_M		8
# define CLKEN_GPIO_M_PCLK		28
#define CLKEN_WDT		9
# define CLKEN_WDT_DCLK			28
# define CLKEN_WDT_PCLK			29
#define CLKEN_TIMER		10
# define CLKEN_TIMER_PCLK(x)		((x) << 1)
# define CLKEN_TIMER_DCLK(x)		(((x) << 1) + 1)
#define CLKEN_SIO_M		11
# define CLKEN_SIO_M_PCLK		8
# define CLKEN_SIO_M_DCLK		9
#define CLKEN_MS		14
# define CLKEN_MS_DCLK			8
# define CLKEN_MS_HCLK			9
# define CLKEN_MS_DVEN			10

/* PLLs */
#define PLL_GCRG(ch)	(1 + (ch))
#define PLL_LCRG(ch)	(32 + (ch))

/* Select */
#define CLKSEL_MEDIA	1

#endif /* __REGS_CLK_H */
