/*
 * mach-cxd90xxx/include/mach/regs-srst.h
 *
 * CXD90XXX software reset registers
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __REGS_SRST_H
#define __REGS_SRST_H

#include <mach/regs-scu.h>
#define SRST_DATA	SCU_DATA
#define SRST_SET	SCU_SET
#define SRST_CLR	SCU_CLR

/* channels */
#define SRST_UART_C_GRP		4
# define SRST_UART_C_BIT		8
# define SRST_UART_C_DLY		20 /* nsec */
#define SRST_GPIO_C_GRP		4
# define SRST_GPIO_C_BIT		24
# define SRST_GPIO_C_DLY		20 /* nsec */
#define SRST_GPIOINT_C_GRP	4
# define SRST_GPIOINT_C_BIT		25
# define SRST_GPIOINT_C_DLY		20 /* nsec */
#define SRST_SIO_C_GRP		5
# define SRST_SIO_C_BIT			0
# define SRST_SIO_C_DLY			0
#define SRST_CPUINT_M_GRP	8
# define SRST_CPUINT_M_BIT		4
# define SRST_CPUINT_M_DLY		20 /* nsec */
#define SRST_LDEC_GRP		8
# define SRST_LDEC_BIT			8
# define SRST_LDEC_DLY			20 /* nsec */
#define SRST_FECCNT_GRP		8
# define SRST_FECCNT_BIT		12
# define SRST_FECCNT_DLY		20 /* nsec */
#define SRST_CMMC_GRP		8
# define SRST_CMMC_BIT			24
# define SRST_CMMC_DLY			20 /* nsec */
#define SRST_GPIO_M_GRP		8
# define SRST_GPIO_M_BIT		28
# define SRST_GPIO_M_DLY		20 /* nsec */
#define SRST_WDT		9
# define SRST_WDT_DRST			28
# define SRST_WDT_PRST			29
# define SRST_WDT_PRST_DLY		30 /* nsec */
#define SRST_TIMER		10
# define SRST_TIMER_RST(x)		((x) << 1)
# define SRST_TIMER_DLY			20 /* nsec */
#define SRST_SIO_M_GRP		11
# define SRST_SIO_M_BIT			8
# define SRST_SIO_M_DLY			0
#define SRST_MS_GRP		14
# define SRST_MS_BIT			8
# define SRST_MS_DLY			0

#endif /* __REGS_SRST_H */
