/*
 * drivers/soc/cxd/export/uart_addr.h
 *
 * UART address
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#ifndef __ARCH_CXD90XXX_UART_ADDR_H__
#define __ARCH_CXD90XXX_UART_ADDR_H__

#if defined(CONFIG_ARCH_CXD90XXX_FVP)
# define UARTPA 0x1C090000
# define UARTVA_EARLY 0xffffffc020090000
# define UARTVA_IOMAP UARTVA_EARLY
#elif defined(CONFIG_ARCH_CXD90XXX_QEMU)
# define UARTPA 0x09000000
# define UARTVA_EARLY 0xffffffc020000000
# define UARTVA_IOMAP UARTVA_EARLY
#elif defined(CONFIG_DEBUG_UART_8250)
# define UARTPA 0xfc592000
# define UARTVA_EARLY 0xffffffc020592000
# define UARTVA_IOMAP 0xfffffffffc592000
#elif defined(CONFIG_DEBUG_UART_PL011)
# define UARTPA 0xf1000000
# define UARTVA_EARLY 0xffffffc020000000
# define UARTVA_IOMAP 0xfffffffff1000000
#else
# error "Unknown UART"
#endif

#endif /* !__ARCH_CXD90XXX_UART_ADDR_H__ */
