#ifndef __MACH_UDIF_RESET_H__
#define __MACH_UDIF_RESET_H__

typedef struct {
	UDIF_VA		assert;
	UDIF_VA		negate;
	UDIF_U32	shift;
	UDIF_U32	delay; /* nsec */
} UDIF_RST_CTL;

typedef struct {
	UDIF_RST_CTL	hrst;
	UDIF_RST_CTL	drst;
} UDIF_RESET;

#define UDIF_RST_CTL_INIT(a,n,sh,dly)		\
{ \
	.assert	= UDIF_IO_ADDRESS(a), \
	.negate	= UDIF_IO_ADDRESS(n), \
	.shift	= (sh), \
	.delay	= (dly), \
}

#define UDIF_RESET_INIT(ha, hn, hsh, hd, da, dn, dsh, dd)	\
{ \
	.hrst	 = UDIF_RST_CTL_INIT((ha), (hn), (hsh), (hd)),	\
	.drst	 = UDIF_RST_CTL_INIT((da), (dn), (dsh), (dd)), \
}

extern UDIF_ERR __udif_devio_hrst(UDIF_RESET *reset, UDIF_U8 assert);
extern UDIF_ERR __udif_devio_devrst(UDIF_RESET *reset, UDIF_U8 assert);

#endif /* __MACH_UDIF_RESET_H__ */
