/*
 * drivers/soc/cxd/gic.c
 *
 *
 * Copyright 2023 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <linux/io.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <mach/gic_export.h>
#include <mach/irqs.h>

/* lower bound of virq (dynamic allocate) */
unsigned int arch_dynirq_lower_bound(unsigned int from)
{
	return IRQ_GIC_START + NR_GIC_SPI;
}

#ifndef CONFIG_AUTO_IRQ_AFFINITY
static void __init gic_target_cpu(unsigned int irq, unsigned int cpuid)
{
	writeb_relaxed(cpuid, GIC_IRQ_ROUTER(irq));
}
#endif /* CONFIG_AUTO_IRQ_AFFINITY */

#ifndef CONFIG_IRQ_TRIGGER_TAKEOVER
static void __init gic_config_edge(unsigned int irq)
{
	u32 offset, shift, tmp;

	offset = GIC_CONFIG_OFFSET(irq);
	shift  = GIC_CONFIG_DATA_SHIFT(irq);
	/* RMW */
	tmp = readl_relaxed(VA_GIC_DIST+GICD_ICFGR+offset);
	tmp |= GIC_CONFIG_EDGE << shift;
	writel_relaxed(tmp, VA_GIC_DIST+GICD_ICFGR+offset);
}

#define MAX_EDGE	30
static int edge[MAX_EDGE], n_edge;
module_param_array(edge, int, &n_edge, 0444);

static void __init gic_setup_trigger(void)
{
	int i;

	for (i = 0; i < n_edge; i++) {
		if (IRQ_GIC_START <= edge[i]
		    && edge[i] < IRQ_GIC_START+NR_GIC_SPI) {
			printk(KERN_INFO "IRQ%d: edge trigger\n", edge[i]);
			gic_config_edge(edge[i]);
		}
	}
}
#endif /* CONFIG_IRQ_TRIGGER_TAKEOVER */

void __init cxd90xxx_gic_init(void)
{
#if !defined(CONFIG_IRQ_TRIGGER_TAKEOVER)
	gic_setup_trigger();
#endif /* !CONFIG_IRQ_TRIGGER_TAKEOVER */
}
