/*
 * gpio.c
 *
 * GPIO for CXD90XXX
 *
 * Copyright 2022 Sony Corporation
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  version 2 of the  License.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Suite 500, Boston, MA 02110-1335, USA.
 *
 */
#include <linux/module.h>
#include <mach/irqs.h>

#define GPIO_INT0_PORT	0x42
#define GPIO_INT0_MASK	0xffffU
#define GPIO_INT0_IRQ	IRQ_GPIO_BASE
#define GPIO_INT1_PORT	0x43
#define GPIO_INT1_MASK	0x0fffU
#define GPIO_INT1_IRQ	(IRQ_GPIO_BASE+16)

/*
 * NAME
 * 	gpiopin_to_irq
 * SYNOPSIS
 *	#include <mach/irqs.h>
 *	int gpiopin_to_irq(unsigned int port, unsigned int bit);
 * INPUT
 *	port: GPIO port number (0x42,0x43=GPIO_INT)
 *       bit: GPIO bit number (0..15)
 * RETURN VALUE
 *      IRQ number
 *	  If input is out of range, -1 shall be returned.
 */
int gpiopin_to_irq(unsigned int port, unsigned int bit)
{
	int irq = -1;
	unsigned int mask;
	int base;

	switch (port) {
	case GPIO_INT0_PORT:
		mask = GPIO_INT0_MASK;
		base = GPIO_INT0_IRQ;
		break;
	case GPIO_INT1_PORT:
		mask = GPIO_INT1_MASK;
		base = GPIO_INT1_IRQ;
		break;
	default:
		return irq;
	}
	if (BIT(bit) & mask) {
		irq = base + bit;
	}
	return irq;
}
EXPORT_SYMBOL(gpiopin_to_irq);
