/*
 * drivers/soc/cxd/head.S
 *
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm64/kernel/head.S.
 */
/*
 * Low-level CPU initialisation
 * Based on arch/arm/kernel/head.S
 *
 * Copyright (C) 1994-2002 Russell King
 * Copyright (C) 2003-2012 ARM Ltd.
 * Authors:	Catalin Marinas <catalin.marinas@arm.com>
 *		Will Deacon <will.deacon@arm.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/linkage.h>
#include <linux/init.h>
#include <asm/assembler.h>
#include <asm/cputype.h>
#include "include/head_init.h"

	__INIT

	.align	3
SYM_DATA_START(__text_vector)
	.quad   _text - .
SYM_DATA_END(__text_vector)

SYM_FUNC_START(ej_head_init)
	// preserve: x0-x3 (for QEMU and FVP)
	// destroy: x28, x10
	mov	x28, lr			// save LR

	// SMP common entry
	mrs	x10, mpidr_el1
	ands	x10, x10, #MPIDR_LEVEL_MASK	// CPU#
	b.ne	ej_secondary_entry

	// CPU#0
	bootcpu_enter			// preserve x28

#if defined(CONFIG_DEBUG_EARLY) || defined(CONFIG_CXD90XXX_UART_IO_INIT)
	bl	uart_init
#endif
#ifdef CONFIG_DEBUG_EARLY
	mov	w8, #'0'
	bl	_printch
#endif
#if !defined(CONFIG_ARCH_CXD90XXX_QEMU) && !defined(CONFIG_ARCH_CXD90XXX_FVP)
	bl	timer_init
#endif

	bl	v8_boot

	bootcpu_leave			// preserve x28

	ret	x28
SYM_FUNC_END(ej_head_init)

	.align 3
SYM_DATA_START(__secondary_vector)
	.quad   ej_secondary_entry - .
SYM_DATA_END(__secondary_vector)

SYM_FUNC_START(ej_secondary_entry)
	secondary_enter

	mrs	x10, CurrentEL
	cmp	x10, CurrentEL_EL3
	b.ne	1f
	bl	gic_cpu_init
	bl	el3_setup
1:
	smp_enable

	secondary_leave

	mov	x0, xzr
	mov	x1, xzr
	mov	x2, xzr
	mov	x3, xzr

	/* spin-table */
spin:
	wfe
	adr_l	x10, mach_cpu_release_addr
	ldr	x10, [x10]
	cbz	x10, spin
	b	secondary_holding_pen		// x10
SYM_FUNC_END(ej_secondary_entry)
	.ltorg

	.pushsection ".data", "aw"
	.globl mach_cpu_release_addr
	.align 3
mach_cpu_release_addr:	.quad	0
	.popsection
