/*
 * arch/arm64/include/asm/debug-8250.S
 *
 * Debugging macro include header
 *
 * Copyright 2022 Sony Corporation
 *
 * This code is based on arch/arm/include/debug/8250.S
 */
/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * arch/arm/include/debug/8250.S
 *
 *  Copyright (C) 1994-2013 Russell King
 */
#include <linux/serial_reg.h>
#include <mach/platform.h>
#include <mach/regs-clk.h>
#include <mach/regs-srst.h>

		.macro	senduart,rd,rx
		str	\rd, [\rx, #UART_TX << UART_SHIFT]
		.endm

		.macro	waituart,rd,rx
		.endm

		.macro	busyuart,rd,rx
1002:		ldr	\rd, [\rx, #UART_LSR << UART_SHIFT]
		ands	\rd, \rd, #UART_LSR_TEMT
		beq	1002b
		.endm

		.macro	uart_setup
		/* CLK */
		ldr	x5, =CXD90XXX_CLKEN(CLKEN_UART_C)
		mov	w6, #1U << CLKEN_UART_C_PCLK
		str	w6, [x5, #CLK_SET]
		/* RESET */
		ldr	x5, =CXD90XXX_RESET(SRST_UART_C_GRP)
		mov	w6, #1U << SRST_UART_C_BIT
		str	w6, [x5, #SRST_SET]
		/* wait 1CLK (dummy read) */
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		ldr	w6, [x5, #SRST_DATA]
		/* setup 8250 */
		ldr	x5, =UARTPA
	 	mov	w6, #UART_LCR_DLAB
		str	w6, [x5, #UART_LCR << UART_SHIFT]
		mov	w6, #__UART_BAUD_F
		str	w6, [x5, #UART_DLF << UART_SHIFT]
		mov	w6, #__UART_BAUD_I_L
		str	w6, [x5, #UART_DLL << UART_SHIFT]
		mov	w6, #__UART_BAUD_I_H
		str	w6, [x5, #UART_DLM << UART_SHIFT]
	 	mov	w6, #UART_LCR_WLEN8
		str	w6, [x5, #UART_LCR << UART_SHIFT]
		str	wzr, [x5, #UART_FCR << UART_SHIFT]
		str	wzr, [x5, #UART_IER << UART_SHIFT]
		.endm
